/*
 * Decompiled with CFR 0.152.
 */
package com.dtsx.astra.sdk.cassio;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.dtsx.astra.sdk.cassio.AbstractCassandraTable;
import com.dtsx.astra.sdk.cassio.CassandraSimilarityMetric;
import com.dtsx.astra.sdk.cassio.ClusteredMetadataVectorRecord;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusteredMetadataVectorTable
extends AbstractCassandraTable<ClusteredMetadataVectorRecord> {
    private static final Logger log = LoggerFactory.getLogger(ClusteredMetadataVectorTable.class);
    private final int vectorDimension;
    private final CassandraSimilarityMetric similarityMetric;
    private PreparedStatement findPartitionStatement;
    private PreparedStatement deletePartitionStatement;
    private PreparedStatement deleteRowStatement;
    private PreparedStatement insertRowStatement;
    private PreparedStatement findRowStatement;

    public ClusteredMetadataVectorTable(@NonNull CqlSession session, @NonNull String keyspaceName, @NonNull String tableName, @NonNull Integer vectorDimension, @NonNull CassandraSimilarityMetric metric) {
        super(session, keyspaceName, tableName);
        if (session == null) {
            throw new NullPointerException("session is marked non-null but is null");
        }
        if (keyspaceName == null) {
            throw new NullPointerException("keyspaceName is marked non-null but is null");
        }
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        if (vectorDimension == null) {
            throw new NullPointerException("vectorDimension is marked non-null but is null");
        }
        if (metric == null) {
            throw new NullPointerException("metric is marked non-null but is null");
        }
        this.vectorDimension = vectorDimension;
        this.similarityMetric = metric;
    }

    public static Builder builder() {
        return new Builder();
    }

    private synchronized void prepareStatements() {
        if (this.findPartitionStatement == null) {
            this.findPartitionStatement = this.cqlSession.prepare("select * from " + this.keyspaceName + "." + this.tableName + " where partition_id = ? ");
            this.deletePartitionStatement = this.cqlSession.prepare("delete from " + this.keyspaceName + "." + this.tableName + " where partition_id = ? ");
            this.findRowStatement = this.cqlSession.prepare("select * from " + this.keyspaceName + "." + this.tableName + " where partition_id = ?  and row_id = ? ");
            this.deleteRowStatement = this.cqlSession.prepare("delete from " + this.keyspaceName + "." + this.tableName + " where partition_id = ?  and row_id = ? ");
            this.insertRowStatement = this.cqlSession.prepare("insert into " + this.keyspaceName + "." + this.tableName + " (partition_id, row_id, body_blob)  values (?, ?, ?)");
        }
    }

    @Override
    public void create() {
        this.cqlSession.execute("CREATE TABLE IF NOT EXISTS " + this.tableName + " (partition_iduuid,row_idtext, attributes_blob text, body_blob text, metadata_s map<text, text>, vector vector<float, " + this.vectorDimension + ">, PRIMARY KEY ((partition_id), row_id)) WITH CLUSTERING ORDER BY (row_id DESC)");
        this.cqlSession.execute("CREATE CUSTOM INDEX IF NOT EXISTS idx_vector_" + this.tableName + " ON " + this.tableName + " (vector) USING 'org.apache.cassandra.index.sai.StorageAttachedIndex' WITH OPTIONS = { 'similarity_function': '" + this.similarityMetric.getOption() + "'};");
        log.info("+ Index '{}' has been created (if needed).", (Object)("idx_vector_" + this.tableName));
        this.cqlSession.execute("CREATE CUSTOM INDEX IF NOT EXISTS eidx_metadata_s_" + this.tableName + " ON " + this.tableName + " (ENTRIES(metadata_s)) USING 'org.apache.cassandra.index.sai.StorageAttachedIndex' ");
        log.info("+ Index '{}' has been created (if needed).", (Object)("eidx_metadata_s_" + this.tableName));
    }

    @Override
    public void put(ClusteredMetadataVectorRecord row) {
    }

    @Override
    public ClusteredMetadataVectorRecord mapRow(Row row) {
        return null;
    }

    public static class Builder {
        private CqlSession session;
        private String keyspaceName;
        private String tableName;
        private Integer vectorDimension;
        private CassandraSimilarityMetric metric = CassandraSimilarityMetric.COSINE;

        public Builder withSession(CqlSession session) {
            this.session = session;
            return this;
        }

        public Builder withKeyspaceName(String keyspaceName) {
            this.keyspaceName = keyspaceName;
            return this;
        }

        public Builder withTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder withVectorDimension(Integer vectorDimension) {
            this.vectorDimension = vectorDimension;
            return this;
        }

        public Builder withMetric(CassandraSimilarityMetric metric) {
            this.metric = metric;
            return this;
        }

        public ClusteredMetadataVectorTable build() {
            return new ClusteredMetadataVectorTable(this.session, this.keyspaceName, this.tableName, this.vectorDimension, this.metric);
        }
    }

    public static class Record {
    }
}

