/*
 * Decompiled with CFR 0.152.
 */
package com.dtsx.astra.sdk;

import io.stargate.sdk.core.domain.Page;
import io.stargate.sdk.data.CollectionClient;
import io.stargate.sdk.data.domain.DocumentMutationResult;
import io.stargate.sdk.data.domain.JsonDocument;
import io.stargate.sdk.data.domain.JsonDocumentMutationResult;
import io.stargate.sdk.data.domain.JsonDocumentResult;
import io.stargate.sdk.data.domain.JsonResultUpdate;
import io.stargate.sdk.data.domain.UpdateStatus;
import io.stargate.sdk.data.domain.odm.Document;
import io.stargate.sdk.data.domain.odm.DocumentResult;
import io.stargate.sdk.data.domain.odm.DocumentResultMapper;
import io.stargate.sdk.data.domain.query.DeleteQuery;
import io.stargate.sdk.data.domain.query.Filter;
import io.stargate.sdk.data.domain.query.SelectQuery;
import io.stargate.sdk.data.domain.query.SelectQueryBuilder;
import io.stargate.sdk.data.domain.query.UpdateQuery;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import lombok.NonNull;

public class AstraDBCollection {
    CollectionClient collectionClient;

    AstraDBCollection(CollectionClient collectionClient) {
        this.collectionClient = collectionClient;
    }

    public final JsonDocumentMutationResult insertOne(String json) {
        return this.collectionClient.insertOne(json);
    }

    public final CompletableFuture<JsonDocumentMutationResult> insertOneAsync(String json) {
        return this.collectionClient.insertOneAsync(json);
    }

    public final JsonDocumentMutationResult insertOne(JsonDocument document) {
        return this.collectionClient.insertOne(document);
    }

    public final CompletableFuture<JsonDocumentMutationResult> insertOneASync(JsonDocument document) {
        return this.collectionClient.insertOneAsync(document);
    }

    public final <DOC> DocumentMutationResult<DOC> insertOne(Document<DOC> document) {
        return this.collectionClient.insertOne(document);
    }

    public final <DOC> CompletableFuture<DocumentMutationResult<DOC>> insertOneASync(Document<DOC> document) {
        return this.collectionClient.insertOneASync(document);
    }

    public final JsonDocumentMutationResult upsertOne(String json) {
        return this.collectionClient.upsertOne(json);
    }

    public final CompletableFuture<JsonDocumentMutationResult> upsertOneASync(String json) {
        return this.collectionClient.upsertOneAsync(json);
    }

    public final JsonDocumentMutationResult upsertOne(JsonDocument document) {
        return this.collectionClient.upsertOne(document);
    }

    public final CompletableFuture<JsonDocumentMutationResult> upsertOneASync(JsonDocument document) {
        return CompletableFuture.supplyAsync(() -> this.collectionClient.upsertOne(document));
    }

    public final <DOC> DocumentMutationResult<DOC> upsertOne(Document<DOC> document) {
        return this.collectionClient.upsertOne(document);
    }

    public final <DOC> CompletableFuture<DocumentMutationResult<DOC>> upsertOneASync(Document<DOC> document) {
        return this.collectionClient.upsertOneASync(document);
    }

    public final List<JsonDocumentMutationResult> insertMany(String json) {
        return this.collectionClient.insertMany(json);
    }

    public final CompletableFuture<List<JsonDocumentMutationResult>> insertManyASync(String json) {
        return this.collectionClient.insertManyASync(json);
    }

    public final List<JsonDocumentMutationResult> insertManyJsonDocuments(List<JsonDocument> documents) {
        return this.collectionClient.insertManyJsonDocuments(documents);
    }

    public final CompletableFuture<List<JsonDocumentMutationResult>> insertManyJsonDocumentsASync(List<JsonDocument> documents) {
        return this.collectionClient.insertManyJsonDocumentsASync(documents);
    }

    public final <DOC> List<DocumentMutationResult<DOC>> insertMany(List<Document<DOC>> documents) {
        return this.collectionClient.insertMany(documents);
    }

    public final <DOC> CompletableFuture<List<DocumentMutationResult<DOC>>> insertManyASync(List<Document<DOC>> documents) {
        return this.collectionClient.insertManyASync(documents);
    }

    public final <DOC> List<DocumentMutationResult<DOC>> insertManyChunked(List<Document<DOC>> documents, int chunkSize, int concurrency) {
        return this.collectionClient.insertManyChunked(documents, chunkSize, concurrency);
    }

    public final <DOC> CompletableFuture<List<DocumentMutationResult<DOC>>> insertManyChunkedASync(List<Document<DOC>> documents, int chunkSize, int concurrency) {
        return CompletableFuture.supplyAsync(() -> this.insertManyChunked(documents, chunkSize, concurrency));
    }

    public final List<JsonDocumentMutationResult> insertManyChunkedJsonDocuments(List<JsonDocument> documents, int chunkSize, int concurrency) {
        return this.collectionClient.insertManyJsonDocumentsChunked(documents, chunkSize, concurrency);
    }

    public final CompletableFuture<List<JsonDocumentMutationResult>> insertManyChunkedJsonDocumentsAsync(List<JsonDocument> documents, int chunkSize, int concurrency) {
        return CompletableFuture.supplyAsync(() -> this.insertManyChunkedJsonDocuments(documents, chunkSize, concurrency));
    }

    public final List<JsonDocumentMutationResult> upsertMany(String json) {
        return this.collectionClient.upsertMany(json);
    }

    public final CompletableFuture<List<JsonDocumentMutationResult>> upsertManyASync(String json) {
        return this.collectionClient.upsertManyASync(json);
    }

    public final List<JsonDocumentMutationResult> upsertManyJsonDocuments(List<JsonDocument> documents) {
        return this.collectionClient.upsertManyJsonDocuments(documents);
    }

    public final CompletableFuture<List<JsonDocumentMutationResult>> upsertManyJsonDocumentsASync(List<JsonDocument> documents) {
        return this.collectionClient.upsertManyJsonDocumentsASync(documents);
    }

    public final <DOC> List<DocumentMutationResult<DOC>> upsertMany(List<Document<DOC>> documents) {
        return this.collectionClient.upsertMany(documents);
    }

    public final <DOC> CompletableFuture<List<DocumentMutationResult<DOC>>> upsertManyASync(List<Document<DOC>> documents) {
        return this.collectionClient.upsertManyASync(documents);
    }

    public final <DOC> List<DocumentMutationResult<DOC>> upsertManyChunked(List<Document<DOC>> documents, int chunkSize, int concurrency) {
        return this.collectionClient.upsertManyChunked(documents, chunkSize, concurrency);
    }

    public final <DOC> CompletableFuture<List<DocumentMutationResult<DOC>>> upsertManyChunkedASync(List<Document<DOC>> documents, int chunkSize, int concurrency) {
        return this.collectionClient.upsertManyChunkedASync(documents, chunkSize, concurrency);
    }

    public final List<JsonDocumentMutationResult> upsertManyJsonDocumentsChunked(List<JsonDocument> documents, int chunkSize, int concurrency) {
        return this.collectionClient.upsertManyJsonDocumentsChunked(documents, chunkSize, concurrency);
    }

    public final CompletableFuture<List<JsonDocumentMutationResult>> upsertManyJsonDocumentsChunkedAsync(List<JsonDocument> documents, int chunkSize, int concurrency) {
        return this.collectionClient.upsertManyJsonDocumentsChunkedASync(documents, chunkSize, concurrency);
    }

    public Integer countDocuments() {
        return this.collectionClient.countDocuments();
    }

    public Integer countDocuments(Filter jsonFilter) {
        return this.collectionClient.countDocuments(jsonFilter);
    }

    public boolean isDocumentExists(String id) {
        return this.collectionClient.isDocumentExists(id);
    }

    public Optional<JsonDocumentResult> findOne(String rawJsonQuery) {
        return this.collectionClient.findOne(rawJsonQuery);
    }

    public Optional<JsonDocumentResult> findOne(SelectQuery query) {
        return this.collectionClient.findOne(query);
    }

    public <DOC> Optional<DocumentResult<DOC>> findOne(SelectQuery query, Class<DOC> clazz) {
        return this.findOne(query).map(r -> new DocumentResult(r, clazz));
    }

    public <DOC> Optional<DocumentResult<DOC>> findOne(String query, Class<DOC> clazz) {
        return this.findOne(query).map(r -> new DocumentResult(r, clazz));
    }

    public <DOC> Optional<DocumentResult<DOC>> findOne(SelectQuery query, DocumentResultMapper<DOC> mapper) {
        return this.findOne(query).map(arg_0 -> mapper.map(arg_0));
    }

    public <DOC> Optional<DocumentResult<DOC>> findOne(String query, DocumentResultMapper<DOC> mapper) {
        return this.findOne(query).map(arg_0 -> mapper.map(arg_0));
    }

    public Optional<JsonDocumentResult> findById(String id) {
        return this.findOne(SelectQuery.findById((String)id));
    }

    public <DOC> Optional<DocumentResult<DOC>> findById(@NonNull String id, Class<DOC> clazz) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return this.findById(id).map(r -> new DocumentResult(r, clazz));
    }

    public <DOC> Optional<DocumentResult<DOC>> findById(@NonNull String id, DocumentResultMapper<DOC> mapper) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return this.findById(id).map(arg_0 -> mapper.map(arg_0));
    }

    public Optional<JsonDocumentResult> findOneByVector(float[] vector) {
        return this.findOne(SelectQuery.findByVector((float[])vector));
    }

    public <DOC> Optional<DocumentResult<DOC>> findOneByVector(float[] vector, Class<DOC> clazz) {
        return this.findOneByVector(vector).map(r -> new DocumentResult(r, clazz));
    }

    public <DOC> Optional<DocumentResult<DOC>> findOneByVector(float[] vector, DocumentResultMapper<DOC> mapper) {
        return this.findOneByVector(vector).map(arg_0 -> mapper.map(arg_0));
    }

    public Stream<JsonDocumentResult> find(SelectQuery query) {
        return this.collectionClient.find(query);
    }

    public Page<JsonDocumentResult> findPage(SelectQuery pagedQuery) {
        return this.collectionClient.findPage(pagedQuery);
    }

    public Page<JsonDocumentResult> findPage(String pagedQuery) {
        return this.collectionClient.findPage(pagedQuery);
    }

    public <DOC> Stream<DocumentResult<DOC>> find(SelectQuery query, Class<DOC> clazz) {
        return this.collectionClient.find(query, clazz);
    }

    public <DOC> Stream<DocumentResult<DOC>> find(SelectQuery query, DocumentResultMapper<DOC> mapper) {
        return this.collectionClient.find(query, mapper);
    }

    public Stream<JsonDocumentResult> findAll() {
        return this.collectionClient.findAll();
    }

    public <DOC> Stream<DocumentResult<DOC>> findAll(Class<DOC> clazz) {
        return this.collectionClient.findAll(clazz);
    }

    public <DOC> Stream<DocumentResult<DOC>> findAll(DocumentResultMapper<DOC> mapper) {
        return this.collectionClient.findAll(mapper);
    }

    public <T> Page<DocumentResult<T>> findPage(SelectQuery query, Class<T> clazz) {
        return this.collectionClient.findPage(query, clazz);
    }

    public int deleteOne(DeleteQuery deleteQuery) {
        return this.collectionClient.deleteOne(deleteQuery);
    }

    public int deleteById(String id) {
        return this.deleteOne(DeleteQuery.deleteById((String)id));
    }

    public int deleteByVector(float[] vector) {
        return this.deleteOne(DeleteQuery.deleteByVector((float[])vector));
    }

    public int deleteMany(DeleteQuery deleteQuery) {
        return this.collectionClient.deleteMany(deleteQuery);
    }

    public int deleteAll() {
        return this.deleteMany(null);
    }

    public JsonResultUpdate findOneAndUpdate(UpdateQuery query) {
        return this.collectionClient.findOneAndDelete(query);
    }

    public JsonResultUpdate findOneAndReplace(UpdateQuery query) {
        return this.collectionClient.findOneAndReplace(query);
    }

    public JsonResultUpdate findOneAndDelete(UpdateQuery query) {
        return this.collectionClient.findOneAndDelete(query);
    }

    public UpdateStatus updateOne(UpdateQuery query) {
        return this.collectionClient.updateOne(query);
    }

    public UpdateStatus updateMany(UpdateQuery query) {
        return this.collectionClient.updateMany(query);
    }

    public Stream<JsonDocumentResult> findVector(float[] vector, Integer limit) {
        return this.findVector(vector, (Filter)null, limit);
    }

    public Stream<JsonDocumentResult> findVector(float[] vector, Filter filter, Integer limit) {
        return this.find(SelectQuery.builder().withFilter(filter).orderByAnn(vector).withLimit(limit).includeSimilarity().build());
    }

    public Page<JsonDocumentResult> findVectorPage(SelectQuery query) {
        return this.findPage(query);
    }

    public Page<JsonDocumentResult> findVectorPage(float[] vector, Filter filter, Integer limit, String pagingState) {
        return this.findVectorPage(SelectQuery.builder().withFilter(filter).orderByAnn(vector).withLimit(limit).withPagingState(pagingState).includeSimilarity().build());
    }

    public <DOC> Page<DocumentResult<DOC>> findVectorPage(float[] vector, Filter filter, Integer limit, String pagingState, Class<DOC> clazz) {
        return this.collectionClient.findVectorPage(vector, filter, limit, pagingState, clazz);
    }

    public <DOC> Page<DocumentResult<DOC>> findVectorPage(float[] vector, Filter filter, Integer limit, String pagingState, DocumentResultMapper<DOC> mapper) {
        return this.collectionClient.findVectorPage(vector, filter, limit, pagingState, mapper);
    }

    public Stream<JsonDocumentResult> findVector(float[] vector) {
        return this.find(SelectQuery.findByVector((float[])vector));
    }

    public Stream<JsonDocumentResult> findVector(float[] vector, Filter filter, int recordCount) {
        return this.findVector(SelectQuery.builder().includeSimilarity().withFilter(filter).withLimit(Integer.valueOf(recordCount)).orderByAnn(vector).build());
    }

    public <T> Stream<DocumentResult<T>> findVector(float[] vector, Class<T> clazz) {
        return this.findVector(vector).map(r -> new DocumentResult(r, clazz));
    }

    public <T> Stream<DocumentResult<T>> findVector(float[] vector, DocumentResultMapper<T> mapper) {
        return this.findVector(vector).map(arg_0 -> mapper.map(arg_0));
    }

    public Stream<JsonDocumentResult> findVector(SelectQuery query) {
        return this.find(query);
    }

    public <T> Stream<DocumentResult<T>> findVector(SelectQuery query, Class<T> clazz) {
        return this.findVector(query).map(r -> new DocumentResult(r, clazz));
    }

    public <T> Stream<DocumentResult<T>> findVector(SelectQuery query, DocumentResultMapper<T> mapper) {
        return this.findVector(query).map(arg_0 -> mapper.map(arg_0));
    }

    public Stream<JsonDocumentResult> findVector(float[] vector, Filter filter, Integer limit, boolean includeSimilarity) {
        SelectQueryBuilder builder = SelectQuery.builder().withFilter(filter).withLimit(limit).orderByAnn(vector);
        if (includeSimilarity) {
            builder.includeSimilarity();
        }
        return this.findVector(builder.build());
    }

    public Page<JsonDocumentResult> findPageVector(SelectQuery query) {
        return this.findPage(query);
    }

    public CollectionClient getRawCollectionClient() {
        return this.collectionClient;
    }

    public void enableOrderingWhenInsert() {
        this.collectionClient.setInsertManyOrdered(true);
    }

    public void disableOrderingWhenInsert() {
        this.collectionClient.setInsertManyOrdered(false);
    }

    public CollectionClient getCollectionClient() {
        return this.collectionClient;
    }
}

