/*
 * Decompiled with CFR 0.152.
 */
package com.dtsx.astra.sdk;

import com.dtsx.astra.sdk.AstraDBCollection;
import com.dtsx.astra.sdk.AstraDBRepository;
import com.dtsx.astra.sdk.db.AstraDBOpsClient;
import com.dtsx.astra.sdk.db.domain.Database;
import com.dtsx.astra.sdk.db.exception.DatabaseNotFoundException;
import com.dtsx.astra.sdk.utils.ApiLocator;
import com.dtsx.astra.sdk.utils.AstraEnvironment;
import io.stargate.sdk.Service;
import io.stargate.sdk.ServiceDeployment;
import io.stargate.sdk.api.SimpleTokenProvider;
import io.stargate.sdk.api.TokenProvider;
import io.stargate.sdk.data.DataApiClient;
import io.stargate.sdk.data.NamespaceClient;
import io.stargate.sdk.data.domain.CollectionDefinition;
import io.stargate.sdk.data.domain.SimilarityMetric;
import io.stargate.sdk.http.ServiceHttp;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AstraDB {
    private static final Logger log = LoggerFactory.getLogger(AstraDB.class);
    protected final AstraEnvironment env;
    private final DataApiClient apiClient;
    private final NamespaceClient nsClient;
    private final String apiEndpoint;

    public AstraDB(String token, String apiEndpoint) {
        this(token, apiEndpoint, "default_keyspace");
    }

    public AstraDB(@NonNull String token, @NonNull String apiEndpoint, @NonNull String keyspace) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (apiEndpoint == null) {
            throw new NullPointerException("apiEndpoint is marked non-null but is null");
        }
        if (keyspace == null) {
            throw new NullPointerException("keyspace is marked non-null but is null");
        }
        if (((String)apiEndpoint).endsWith("com")) {
            apiEndpoint = (String)apiEndpoint + "/api/json";
        }
        this.apiEndpoint = apiEndpoint;
        if (((String)apiEndpoint).contains(AstraEnvironment.PROD.getAppsSuffix())) {
            this.env = AstraEnvironment.PROD;
        } else if (((String)apiEndpoint).contains(AstraEnvironment.TEST.getAppsSuffix())) {
            this.env = AstraEnvironment.TEST;
        } else if (((String)apiEndpoint).contains(AstraEnvironment.DEV.getAppsSuffix())) {
            this.env = AstraEnvironment.DEV;
        } else {
            throw new IllegalArgumentException("Unable to detect environment from endpoint");
        }
        ServiceDeployment jsonDeploy = new ServiceDeployment();
        jsonDeploy.addDatacenterTokenProvider("default", (TokenProvider)new SimpleTokenProvider(token));
        jsonDeploy.addDatacenterServices("default", (Service[])new ServiceHttp[]{new ServiceHttp("json", (String)apiEndpoint, (String)apiEndpoint)});
        this.apiClient = new DataApiClient(jsonDeploy);
        this.nsClient = this.apiClient.namespace(keyspace);
    }

    public AstraDB(@NonNull String token, @NonNull UUID databaseId) {
        this(token, databaseId, null, AstraEnvironment.PROD, "default_keyspace");
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (databaseId == null) {
            throw new NullPointerException("databaseId is marked non-null but is null");
        }
    }

    public AstraDB(@NonNull String token, @NonNull UUID databaseId, @NonNull String keyspace) {
        this(token, databaseId, null, AstraEnvironment.PROD, keyspace);
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (databaseId == null) {
            throw new NullPointerException("databaseId is marked non-null but is null");
        }
        if (keyspace == null) {
            throw new NullPointerException("keyspace is marked non-null but is null");
        }
    }

    public AstraDB(@NonNull String token, @NonNull UUID databaseId, @NonNull String region, @NonNull String keyspace) {
        this(token, databaseId, region, AstraEnvironment.PROD, keyspace);
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (databaseId == null) {
            throw new NullPointerException("databaseId is marked non-null but is null");
        }
        if (region == null) {
            throw new NullPointerException("region is marked non-null but is null");
        }
        if (keyspace == null) {
            throw new NullPointerException("keyspace is marked non-null but is null");
        }
    }

    public AstraDB(@NonNull String token, @NonNull UUID databaseId, String region, @NonNull AstraEnvironment env, String keyspace) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (databaseId == null) {
            throw new NullPointerException("databaseId is marked non-null but is null");
        }
        if (env == null) {
            throw new NullPointerException("env is marked non-null but is null");
        }
        this.env = env;
        Database db = (Database)new AstraDBOpsClient(token, env).findById(databaseId.toString()).orElseThrow(() -> new DatabaseNotFoundException(databaseId.toString()));
        if (region == null) {
            region = db.getInfo().getRegion();
        }
        ServiceDeployment jsonDeploy = new ServiceDeployment();
        jsonDeploy.addDatacenterTokenProvider("default", (TokenProvider)new SimpleTokenProvider(token));
        this.apiEndpoint = ApiLocator.getApiJsonEndpoint((AstraEnvironment)env, (String)databaseId.toString(), (String)region);
        jsonDeploy.addDatacenterServices("default", (Service[])new ServiceHttp[]{new ServiceHttp("json", this.apiEndpoint, this.apiEndpoint)});
        String defaultRegion = region;
        db.getInfo().getDatacenters().stream().filter(dc -> !dc.getRegion().equals(defaultRegion)).forEach(dc -> {
            String dcApiEndpoint = ApiLocator.getApiJsonEndpoint((AstraEnvironment)env, (String)databaseId.toString(), (String)dc.getRegion());
            jsonDeploy.addDatacenterServices(dc.getName(), (Service[])new ServiceHttp[]{new ServiceHttp("json", dcApiEndpoint, dcApiEndpoint)});
        });
        this.apiClient = new DataApiClient(jsonDeploy);
        if (keyspace == null) {
            keyspace = db.getInfo().getKeyspace();
        }
        this.nsClient = this.apiClient.namespace(keyspace);
    }

    public boolean isCollectionExists(@NonNull String store) {
        if (store == null) {
            throw new NullPointerException("store is marked non-null but is null");
        }
        return this.nsClient.isCollectionExists(store);
    }

    public Stream<CollectionDefinition> findAllCollections() {
        return this.nsClient.findCollections();
    }

    public Optional<CollectionDefinition> findCollection(String name) {
        return this.nsClient.findCollectionByName(name);
    }

    public void deleteCollection(String name) {
        this.nsClient.deleteCollection(name);
    }

    public AstraDBCollection createCollection(String name) {
        return new AstraDBCollection(this.nsClient.createCollection(name));
    }

    public <DOC> AstraDBRepository<DOC> createCollection(String name, Class<DOC> clazz) {
        return new AstraDBRepository(this.nsClient.createCollection(name, clazz));
    }

    public AstraDBCollection createCollection(String name, int vectorDimension) {
        return new AstraDBCollection(this.nsClient.createCollection(name, vectorDimension));
    }

    public AstraDBCollection createCollection(String name, int vectorDimension, SimilarityMetric metric) {
        return new AstraDBCollection(this.nsClient.createCollection(CollectionDefinition.builder().name(name).vector(vectorDimension, metric).build()));
    }

    public <T> AstraDBRepository<T> createCollection(String name, int vectorDimension, Class<T> bean) {
        return new AstraDBRepository(this.nsClient.createCollection(CollectionDefinition.builder().name(name).vector(vectorDimension, SimilarityMetric.cosine).build(), bean));
    }

    public AstraDBCollection createCollection(CollectionDefinition def) {
        return new AstraDBCollection(this.nsClient.createCollection(def));
    }

    public <DOC> AstraDBRepository<DOC> createCollection(CollectionDefinition def, Class<DOC> clazz) {
        return new AstraDBRepository(this.nsClient.createCollection(def, clazz));
    }

    public AstraDBCollection collection(@NonNull String storeName) {
        if (storeName == null) {
            throw new NullPointerException("storeName is marked non-null but is null");
        }
        return new AstraDBCollection(this.nsClient.collection(storeName));
    }

    public <T> AstraDBRepository<T> collectionRepository(@NonNull String storeName, Class<T> clazz) {
        if (storeName == null) {
            throw new NullPointerException("storeName is marked non-null but is null");
        }
        return new AstraDBRepository(this.nsClient.collectionRepository(storeName, clazz));
    }

    public NamespaceClient getNamespaceClient() {
        return this.nsClient;
    }

    public AstraEnvironment getEnv() {
        return this.env;
    }

    public DataApiClient getApiClient() {
        return this.apiClient;
    }

    public NamespaceClient getNsClient() {
        return this.nsClient;
    }

    public String getApiEndpoint() {
        return this.apiEndpoint;
    }
}

