/*
 * Decompiled with CFR 0.152.
 */
package com.datasonnet.plugins;

import com.datasonnet.document.DefaultDocument;
import com.datasonnet.document.Document;
import com.datasonnet.document.MediaType;
import com.datasonnet.document.MediaTypes;
import com.datasonnet.spi.AbstractDataFormatPlugin;
import com.datasonnet.spi.PluginException;
import com.datasonnet.spi.ujsonUtils;
import ujson.Null$;
import ujson.Value;

public class DefaultPlainTextFormatPlugin
extends AbstractDataFormatPlugin {
    public DefaultPlainTextFormatPlugin() {
        this.supportedTypes.add(MediaTypes.TEXT_PLAIN);
        this.readerSupportedClasses.add(String.class);
        this.writerSupportedClasses.add(String.class);
    }

    @Override
    public Value read(Document<?> doc) throws PluginException {
        if (doc.getContent() == null) {
            return Null$.MODULE$;
        }
        if (String.class.isAssignableFrom(doc.getContent().getClass())) {
            return ujsonUtils.strValueOf((String)doc.getContent());
        }
        throw new PluginException(new IllegalArgumentException("Unsupported document content class, use the test method canRead before invoking read"));
    }

    @Override
    public <T> Document<T> write(Value input, MediaType mediaType, Class<T> targetType) throws PluginException {
        if (targetType.isAssignableFrom(String.class)) {
            return new DefaultDocument<String>(ujsonUtils.stringValueOf(input), MediaTypes.TEXT_PLAIN);
        }
        throw new IllegalArgumentException("Only strings can be written as plain text.");
    }
}

