/*
 * Decompiled with CFR 0.152.
 */
package com.datasonnet.spi;

import com.datasonnet.document.Document;
import com.datasonnet.document.MediaType;
import com.datasonnet.plugins.DefaultCSVFormatPlugin;
import com.datasonnet.plugins.DefaultJSONFormatPlugin;
import com.datasonnet.plugins.DefaultJavaFormatPlugin;
import com.datasonnet.plugins.DefaultPlainTextFormatPlugin;
import com.datasonnet.plugins.DefaultXMLFormatPlugin$;
import com.datasonnet.spi.DataFormatPlugin;
import com.datasonnet.spi.PluginException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import ujson.Value;

public class DataFormatService {
    private final List<DataFormatPlugin> plugins;
    public static final DataFormatService DEFAULT = new DataFormatService(Arrays.asList(new DefaultJSONFormatPlugin(), new DefaultJavaFormatPlugin(), DefaultXMLFormatPlugin$.MODULE$, new DefaultCSVFormatPlugin(), new DefaultPlainTextFormatPlugin()));

    public DataFormatService(List<DataFormatPlugin> plugins) {
        this.plugins = plugins;
    }

    public List<DataFormatPlugin> getPlugins() {
        return Collections.unmodifiableList(this.plugins);
    }

    public Optional<DataFormatPlugin> thatCanWrite(MediaType output, Class<?> target) {
        for (DataFormatPlugin plugin : this.plugins) {
            if (!plugin.canWrite(output, target)) continue;
            return Optional.of(plugin);
        }
        return Optional.empty();
    }

    public Optional<DataFormatPlugin> thatCanRead(Document<?> doc) {
        for (DataFormatPlugin plugin : this.plugins) {
            if (!plugin.canRead(doc)) continue;
            return Optional.of(plugin);
        }
        return Optional.empty();
    }

    public <T> Document<T> mandatoryWrite(Value input, MediaType mediaType, Class<T> targetType) throws PluginException {
        return this.thatCanWrite(mediaType, targetType).orElseThrow(() -> new IllegalArgumentException("The output MediaType " + mediaType + " is not supported for class" + targetType)).write(input, mediaType, targetType);
    }

    public Value mandatoryRead(Document<?> doc) throws PluginException {
        return this.thatCanRead(doc).orElseThrow(() -> new IllegalArgumentException("The input MediaType " + doc.getMediaType() + " is not supported for class" + doc.getContent().getClass())).read(doc);
    }
}

