/*
 * Decompiled with CFR 0.152.
 */
package com.datasonnet.document;

import com.datasonnet.document.MediaType;
import java.util.Optional;

public class MediaTypes {
    public static final MediaType ANY = new MediaType("*", "*");
    public static final String ANY_VALUE = "*/*";
    public static final MediaType APPLICATION_ATOM_XML = new MediaType("application", "atom+xml");
    public static final String APPLICATION_ATOM_XML_VALUE = "application/atom+xml";
    public static final MediaType APPLICATION_CBOR = new MediaType("application", "cbor");
    public static final String APPLICATION_CBOR_VALUE = "application/cbor";
    public static final MediaType APPLICATION_FORM_URLENCODED = new MediaType("application", "x-www-form-urlencoded");
    public static final String APPLICATION_FORM_URLENCODED_VALUE = "application/x-www-form-urlencoded";
    public static final MediaType APPLICATION_JSON = new MediaType("application", "json");
    public static final String APPLICATION_JSON_VALUE = "application/json";
    public static final MediaType APPLICATION_OCTET_STREAM = new MediaType("application", "octet-stream");
    public static final String APPLICATION_OCTET_STREAM_VALUE = "application/octet-stream";
    public static final MediaType APPLICATION_PDF = new MediaType("application", "pdf");
    public static final String APPLICATION_PDF_VALUE = "application/pdf";
    public static final MediaType APPLICATION_PROBLEM_JSON = new MediaType("application", "problem+json");
    public static final String APPLICATION_PROBLEM_JSON_VALUE = "application/problem+json";
    public static final MediaType APPLICATION_PROBLEM_XML = new MediaType("application", "problem+xml");
    public static final String APPLICATION_PROBLEM_XML_VALUE = "application/problem+xml";
    public static final MediaType APPLICATION_RSS_XML = new MediaType("application", "rss+xml");
    public static final String APPLICATION_RSS_XML_VALUE = "application/rss+xml";
    public static final MediaType APPLICATION_STREAM_JSON = new MediaType("application", "stream+json");
    public static final String APPLICATION_STREAM_JSON_VALUE = "application/stream+json";
    public static final MediaType APPLICATION_XHTML_XML = new MediaType("application", "xhtml+xml");
    public static final String APPLICATION_XHTML_XML_VALUE = "application/xhtml+xml";
    public static final MediaType APPLICATION_XML = new MediaType("application", "xml");
    public static final String APPLICATION_XML_VALUE = "application/xml";
    public static final MediaType IMAGE_GIF = new MediaType("image", "gif");
    public static final String IMAGE_GIF_VALUE = "image/gif";
    public static final MediaType IMAGE_JPEG = new MediaType("image", "jpeg");
    public static final String IMAGE_JPEG_VALUE = "image/jpeg";
    public static final MediaType IMAGE_PNG = new MediaType("image", "png");
    public static final String IMAGE_PNG_VALUE = "image/png";
    public static final MediaType MULTIPART_FORM_DATA = new MediaType("multipart", "form-data");
    public static final String MULTIPART_FORM_DATA_VALUE = "multipart/form-data";
    public static final MediaType MULTIPART_MIXED = new MediaType("multipart", "mixed");
    public static final String MULTIPART_MIXED_VALUE = "multipart/mixed";
    public static final MediaType MULTIPART_RELATED = new MediaType("multipart", "related");
    public static final String MULTIPART_RELATED_VALUE = "multipart/related";
    public static final MediaType TEXT_EVENT_STREAM = new MediaType("text", "event-stream");
    public static final String TEXT_EVENT_STREAM_VALUE = "text/event-stream";
    public static final MediaType TEXT_HTML = new MediaType("text", "html");
    public static final String TEXT_HTML_VALUE = "text/html";
    public static final MediaType TEXT_MARKDOWN = new MediaType("text", "markdown");
    public static final String TEXT_MARKDOWN_VALUE = "text/markdown";
    public static final MediaType TEXT_PLAIN = new MediaType("text", "plain");
    public static final String TEXT_PLAIN_VALUE = "text/plain";
    public static final MediaType TEXT_XML = new MediaType("text", "xml");
    public static final String TEXT_XML_VALUE = "text/xml";
    public static final MediaType APPLICATION_JAVA = new MediaType("application", "x-java-object");
    public static final String APPLICATION_JAVA_VALUE = "application/x-java-object";
    public static final MediaType APPLICATION_CSV = new MediaType("application", "csv");
    public static final String APPLICATION_CSV_VALUE = "application/csv";
    public static final MediaType UNKNOWN = new MediaType("unknown", "unknown");
    public static final String UNKNOWN_VALUE = "unknown/unknown";
    public static final String PARAM_CHARSET = "charset";
    public static final String PARAM_QUALITY_FACTOR = "q";

    public static Optional<MediaType> forExtension(String ext) {
        switch (ext) {
            case "json": {
                return Optional.of(APPLICATION_JSON);
            }
            case "xml": {
                return Optional.of(APPLICATION_XML);
            }
            case "csv": {
                return Optional.of(APPLICATION_CSV);
            }
            case "txt": {
                return Optional.of(TEXT_PLAIN);
            }
        }
        return Optional.empty();
    }
}

