/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.spark.redshift;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.services.s3.AmazonS3Client;
import com.databricks.spark.redshift.AWSCredentialsUtils$;
import com.databricks.spark.redshift.Conversions$;
import com.databricks.spark.redshift.JDBCWrapper;
import com.databricks.spark.redshift.Parameters;
import com.databricks.spark.redshift.RedshiftWriter$;
import com.databricks.spark.redshift.TableName;
import com.databricks.spark.redshift.Utils$;
import java.net.URI;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.Accumulable;
import org.apache.spark.TaskContext$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005%d!B\u0001\u0003\u0001\tQ!A\u0004*fIND\u0017N\u001a;Xe&$XM\u001d\u0006\u0003\u0007\u0011\t\u0001B]3eg\"Lg\r\u001e\u0006\u0003\u000b\u0019\tQa\u001d9be.T!a\u0002\u0005\u0002\u0015\u0011\fG/\u00192sS\u000e\\7OC\u0001\n\u0003\r\u0019w.\\\n\u0003\u0001-\u0001\"\u0001D\b\u000e\u00035Q\u0011AD\u0001\u0006g\u000e\fG.Y\u0005\u0003!5\u0011a!\u00118z%\u00164\u0007\u0002\u0003\n\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000b\u0002\u0017)$'mY,sCB\u0004XM]\u0002\u0001!\t)b#D\u0001\u0003\u0013\t9\"AA\u0006K\t\n\u001buK]1qa\u0016\u0014\b\u0002C\r\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000e\u0002\u001fM\u001c4\t\\5f]R4\u0015m\u0019;pef\u0004B\u0001D\u000e\u001eK%\u0011A$\u0004\u0002\n\rVt7\r^5p]F\u0002\"AH\u0012\u000e\u0003}Q!\u0001I\u0011\u0002\t\u0005,H\u000f\u001b\u0006\u0003E!\t\u0011\"Y7bu>t\u0017m^:\n\u0005\u0011z\"AD!X'\u000e\u0013X\rZ3oi&\fGn\u001d\t\u0003M-j\u0011a\n\u0006\u0003Q%\n!a]\u001a\u000b\u0005)\n\u0013\u0001C:feZL7-Z:\n\u00051:#AD!nCj|gnU\u001aDY&,g\u000e\u001e\u0005\u0006]\u0001!\taL\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007A\n$\u0007\u0005\u0002\u0016\u0001!)!#\fa\u0001)!)\u0011$\fa\u00015!9A\u0007\u0001b\u0001\n\u0013)\u0014a\u00017pOV\ta\u0007\u0005\u00028y5\t\u0001H\u0003\u0002:u\u0005)1\u000f\u001c45U*\t1(A\u0002pe\u001eL!!\u0010\u001d\u0003\r1{wmZ3s\u0011\u0019y\u0004\u0001)A\u0005m\u0005!An\\4!\u0011\u0019\t\u0005\u0001\"\u0001\u0003\u0005\u0006q1M]3bi\u0016$\u0016M\u00197f'FdGcA\"K+B\u0011Ai\u0012\b\u0003\u0019\u0015K!AR\u0007\u0002\rA\u0013X\rZ3g\u0013\tA\u0015J\u0001\u0004TiJLgn\u001a\u0006\u0003\r6AQa\u0013!A\u00021\u000bA\u0001Z1uCB\u0011QjU\u0007\u0002\u001d*\u0011q\nU\u0001\u0004gFd'BA\u0003R\u0015\t\u0011&(\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003):\u0013\u0011\u0002R1uC\u001a\u0013\u0018-\\3\t\u000bY\u0003\u0005\u0019A,\u0002\rA\f'/Y7t!\tAfM\u0004\u0002ZI:\u0011!l\u0019\b\u00037\nt!\u0001X1\u000f\u0005u\u0003W\"\u00010\u000b\u0005}\u001b\u0012A\u0002\u001fs_>$h(C\u0001\n\u0013\t9\u0001\"\u0003\u0002\u0006\r%\u00111\u0001B\u0005\u0003K\n\t!\u0002U1sC6,G/\u001a:t\u0013\t9\u0007N\u0001\tNKJ<W\r\u001a)be\u0006lW\r^3sg*\u0011QM\u0001\u0005\u0006U\u0002!Ia[\u0001\bG>\u0004\u0018pU9m)\u0015\u0019E.\u001d:u\u0011\u0015i\u0017\u000e1\u0001o\u0003)\u0019\u0018\u000f\\\"p]R,\u0007\u0010\u001e\t\u0003\u001b>L!\u0001\u001d(\u0003\u0015M\u000bFjQ8oi\u0016DH\u000fC\u0003WS\u0002\u0007q\u000bC\u0003tS\u0002\u0007Q$A\u0003de\u0016$7\u000fC\u0003vS\u0002\u00071)A\u0006nC:Lg-Z:u+Jd\u0007BB<\u0001\t\u0003\u0011\u00010\u0001\bd_6lWM\u001c;BGRLwN\\:\u0015\u000be\f)!a\u0004\u0011\u0007i|8I\u0004\u0002|{:\u0011Q\f`\u0005\u0002\u001d%\u0011a0D\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t!a\u0001\u0003\t1K7\u000f\u001e\u0006\u0003}6Aq!a\u0002w\u0001\u0004\tI!\u0001\u0007uC\ndWmQ8n[\u0016tG\u000f\u0005\u0003\r\u0003\u0017\u0019\u0015bAA\u0007\u001b\t1q\n\u001d;j_:Dq!!\u0005w\u0001\u0004\t\u0019\"\u0001\u0004tG\",W.\u0019\t\u0005\u0003+\tY\"\u0004\u0002\u0002\u0018)\u0019\u0011\u0011\u0004(\u0002\u000bQL\b/Z:\n\t\u0005u\u0011q\u0003\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007bBA\u0011\u0001\u0011%\u00111E\u0001\u000fI>\u0014V\rZ:iS\u001a$Hj\\1e)1\t)#a\u000b\u0002>\u0005}\u0012\u0011IA\"!\ra\u0011qE\u0005\u0004\u0003Si!\u0001B+oSRD\u0001\"!\f\u0002 \u0001\u0007\u0011qF\u0001\u0005G>tg\u000e\u0005\u0003\u00022\u0005eRBAA\u001a\u0015\ry\u0015Q\u0007\u0006\u0003\u0003o\tAA[1wC&!\u00111HA\u001a\u0005)\u0019uN\u001c8fGRLwN\u001c\u0005\u0007\u0017\u0006}\u0001\u0019\u0001'\t\rY\u000by\u00021\u0001X\u0011\u0019\u0019\u0018q\u0004a\u0001;!9Q/a\bA\u0002\u0005%\u0001bBA$\u0001\u0011%\u0011\u0011J\u0001\u000bk:dw.\u00193ECR\fG\u0003CA\u0005\u0003\u0017\ni%a\u0014\t\r5\f)\u00051\u0001o\u0011\u0019Y\u0015Q\ta\u0001\u0019\"9\u0011\u0011KA#\u0001\u0004\u0019\u0015a\u0002;f[B$\u0015N\u001d\u0005\b\u0003+\u0002A\u0011AA,\u00039\u0019\u0018M^3U_J+Gm\u001d5jMR$\"\"!\n\u0002Z\u0005m\u0013QLA4\u0011\u0019i\u00171\u000ba\u0001]\"11*a\u0015A\u00021C\u0001\"a\u0018\u0002T\u0001\u0007\u0011\u0011M\u0001\tg\u00064X-T8eKB\u0019Q*a\u0019\n\u0007\u0005\u0015dJ\u0001\u0005TCZ,Wj\u001c3f\u0011\u00191\u00161\u000ba\u0001/\u0002")
public class RedshiftWriter {
    public final JDBCWrapper com$databricks$spark$redshift$RedshiftWriter$$jdbcWrapper;
    private final Function1<AWSCredentials, AmazonS3Client> s3ClientFactory;
    private final Logger com$databricks$spark$redshift$RedshiftWriter$$log;

    public Logger com$databricks$spark$redshift$RedshiftWriter$$log() {
        return this.com$databricks$spark$redshift$RedshiftWriter$$log;
    }

    public String createTableSql(DataFrame data, Parameters.MergedParameters params) {
        Option<String> option;
        block4: {
            Option<String> option2;
            block7: {
                String string;
                String distStyleDef;
                String schemaSql;
                block6: {
                    block5: {
                        String string2;
                        block3: {
                            block2: {
                                schemaSql = this.com$databricks$spark$redshift$RedshiftWriter$$jdbcWrapper.schemaString(data.schema());
                                option = params.distStyle();
                                if (!(option instanceof Some)) break block2;
                                Some some = (Some)option;
                                String style = (String)some.x();
                                string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DISTSTYLE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{style}));
                                break block3;
                            }
                            None$ none$ = None$.MODULE$;
                            Option<String> option3 = option;
                            if (none$ != null ? !none$.equals(option3) : option3 != null) break block4;
                            string2 = "";
                        }
                        distStyleDef = string2;
                        option2 = params.distKey();
                        if (!(option2 instanceof Some)) break block5;
                        Some some = (Some)option2;
                        String key = (String)some.x();
                        string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DISTKEY (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key}));
                        break block6;
                    }
                    None$ none$ = None$.MODULE$;
                    Option<String> option4 = option2;
                    if (none$ != null ? !none$.equals(option4) : option4 != null) break block7;
                    string = "";
                }
                String distKeyDef = string;
                String sortKeyDef = (String)params.sortKeySpec().getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                });
                TableName table2 = (TableName)params.table().get();
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE TABLE IF NOT EXISTS ", " (", ") ", " ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table2, schemaSql, distStyleDef, distKeyDef, sortKeyDef}));
            }
            throw new MatchError(option2);
        }
        throw new MatchError(option);
    }

    public String com$databricks$spark$redshift$RedshiftWriter$$copySql(SQLContext sqlContext, Parameters.MergedParameters params, AWSCredentials creds, String manifestUrl) {
        String credsString = AWSCredentialsUtils$.MODULE$.getRedshiftCredentialsString(params, creds);
        String fixedUrl = Utils$.MODULE$.fixS3Url(manifestUrl);
        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"COPY ", " FROM '", "' CREDENTIALS '", "' FORMAT AS "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params.table().get(), fixedUrl, credsString}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"AVRO 'auto' manifest ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params.extraCopyOptions()}))).toString();
    }

    public List<String> commentActions(Option<String> tableComment, StructType schema2) {
        return (List)((List)tableComment.toList().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String desc) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"COMMENT ON TABLE %s IS '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc.replace("'", "''")}));
            }
        }, List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])schema2.fields()).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructField f) {
                return f.metadata().contains("description");
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(StructField f) {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"COMMENT ON COLUMN %s.\"", "\""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{f.name().replace("\"", "\\\"")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" IS '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{f.metadata().getString("description").replace("'", "''")}))).toString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))), List$.MODULE$.canBuildFrom());
    }

    private void doRedshiftLoad(Connection conn, DataFrame data, Parameters.MergedParameters params, AWSCredentials creds, Option<String> manifestUrl) {
        String createStatement = this.createTableSql(data, params);
        this.com$databricks$spark$redshift$RedshiftWriter$$log().info(createStatement);
        this.com$databricks$spark$redshift$RedshiftWriter$$jdbcWrapper.executeInterruptibly(conn.prepareStatement(createStatement));
        List preActions = (List)this.commentActions(params.description(), data.schema()).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])params.preActions()), List$.MODULE$.canBuildFrom());
        preActions.foreach((Function1)new Serializable(this, conn, params){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RedshiftWriter $outer;
            private final Connection conn$1;
            private final Parameters.MergedParameters params$1;

            public final boolean apply(String action) {
                String actionSql = action.contains("%s") ? new StringOps(Predef$.MODULE$.augmentString(action)).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.params$1.table().get()})) : action;
                this.$outer.com$databricks$spark$redshift$RedshiftWriter$$log().info(new StringBuilder().append((Object)"Executing preAction: ").append((Object)actionSql).toString());
                return this.$outer.com$databricks$spark$redshift$RedshiftWriter$$jdbcWrapper.executeInterruptibly(this.conn$1.prepareStatement(actionSql));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.conn$1 = conn$1;
                this.params$1 = params$1;
            }
        });
        manifestUrl.foreach((Function1)new Serializable(this, conn, data, params, creds){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RedshiftWriter $outer;
            private final Connection conn$1;
            private final DataFrame data$1;
            private final Parameters.MergedParameters params$1;
            private final AWSCredentials creds$1;

            public final boolean apply(String manifestUrl) {
                String copyStatement = this.$outer.com$databricks$spark$redshift$RedshiftWriter$$copySql(this.data$1.sqlContext(), this.params$1, this.creds$1, manifestUrl);
                this.$outer.com$databricks$spark$redshift$RedshiftWriter$$log().info(copyStatement);
                try {
                    return this.$outer.com$databricks$spark$redshift$RedshiftWriter$$jdbcWrapper.executeInterruptibly(this.conn$1.prepareStatement(copyStatement));
                }
                catch (SQLException sQLException) {
                    None$ none$;
                    this.$outer.com$databricks$spark$redshift$RedshiftWriter$$log().error("SQLException thrown while running COPY query; will attempt to retrieve more information by querying the STL_LOAD_ERRORS table", (Throwable)sQLException);
                    this.conn$1.rollback();
                    String errorLookupQuery = new StringOps(Predef$.MODULE$.augmentString("\n              | SELECT *\n              | FROM stl_load_errors\n              | WHERE query = pg_last_query_id()\n            ")).stripMargin();
                    try {
                        ResultSet results = this.$outer.com$databricks$spark$redshift$RedshiftWriter$$jdbcWrapper.executeQueryInterruptibly(this.conn$1.prepareStatement(errorLookupQuery));
                        if (results.next()) {
                            int errCode = results.getInt("err_code");
                            String errReason = results.getString("err_reason").trim();
                            String columnLength = (String)Option$.MODULE$.apply((Object)results.getString("col_length")).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply(String x$1) {
                                    return x$1.trim();
                                }
                            }).filter((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(String x$2) {
                                    return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
                                }
                            }).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply(String n) {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{n}));
                                }
                            }).getOrElse((Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "";
                                }
                            });
                            String exceptionMessage = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n                   |Error (code ", ") while loading data into Redshift: \"", "\"\n                   |Table name: ", "\n                   |Column name: ", "\n                   |Column type: ", "", "\n                   |Raw line: ", "\n                   |Raw field value: ", "\n                  "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)errCode), errReason, this.params$1.table().get(), results.getString("colname").trim(), results.getString("type").trim(), columnLength, results.getString("raw_line"), results.getString("raw_field_value")})))).stripMargin();
                            none$ = new Some((Object)new SQLException(exceptionMessage, sQLException));
                        } else {
                            none$ = None$.MODULE$;
                        }
                    }
                    catch (Throwable throwable) {
                        None$ none$2;
                        Throwable throwable2 = throwable;
                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                        if (option.isEmpty()) {
                            throw throwable;
                        }
                        Throwable e2 = (Throwable)option.get();
                        this.$outer.com$databricks$spark$redshift$RedshiftWriter$$log().error("Error occurred while querying STL_LOAD_ERRORS", e2);
                        none$ = none$2 = None$.MODULE$;
                    }
                    None$ detailedException = none$;
                    throw (Throwable)detailedException.getOrElse((Function0)new Serializable(this, sQLException){
                        public static final long serialVersionUID = 0L;
                        private final SQLException e$1;

                        public final SQLException apply() {
                            return this.e$1;
                        }
                        {
                            this.e$1 = e$1;
                        }
                    });
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.conn$1 = conn$1;
                this.data$1 = data$1;
                this.params$1 = params$1;
                this.creds$1 = creds$1;
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])params.postActions()).foreach((Function1)new Serializable(this, conn, params){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RedshiftWriter $outer;
            private final Connection conn$1;
            private final Parameters.MergedParameters params$1;

            public final boolean apply(String action) {
                String actionSql = action.contains("%s") ? new StringOps(Predef$.MODULE$.augmentString(action)).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.params$1.table().get()})) : action;
                this.$outer.com$databricks$spark$redshift$RedshiftWriter$$log().info(new StringBuilder().append((Object)"Executing postAction: ").append((Object)actionSql).toString());
                return this.$outer.com$databricks$spark$redshift$RedshiftWriter$$jdbcWrapper.executeInterruptibly(this.conn$1.prepareStatement(actionSql));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.conn$1 = conn$1;
                this.params$1 = params$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Option<String> unloadData(SQLContext sqlContext, DataFrame data, String tempDir) {
        None$ none$;
        Function1[] conversionFunctions = (Function1[])Predef$.MODULE$.refArrayOps((Object[])data.schema().fields()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Function1<Object, Object> apply(StructField field) {
                Object object;
                DataType dataType = field.dataType();
                DateType$ dateType$ = DateType$.MODULE$;
                DataType dataType2 = dataType;
                if (!(dateType$ != null ? !dateType$.equals(dataType2) : dataType2 != null)) {
                    SimpleDateFormat dateFormat = Conversions$.MODULE$.createRedshiftDateFormat();
                    object = new Serializable(this, dateFormat){
                        public static final long serialVersionUID = 0L;
                        private final SimpleDateFormat dateFormat$1;

                        public final String apply(Object v) {
                            return v == null ? null : this.dateFormat$1.format((Date)v);
                        }
                        {
                            this.dateFormat$1 = dateFormat$1;
                        }
                    };
                } else {
                    TimestampType$ timestampType$ = TimestampType$.MODULE$;
                    DataType dataType3 = dataType;
                    if (!(timestampType$ != null ? !timestampType$.equals(dataType3) : dataType3 != null)) {
                        SimpleDateFormat timestampFormat = Conversions$.MODULE$.createRedshiftTimestampFormat();
                        object = new Serializable(this, timestampFormat){
                            public static final long serialVersionUID = 0L;
                            private final SimpleDateFormat timestampFormat$1;

                            public final String apply(Object v) {
                                return v == null ? null : this.timestampFormat$1.format((Timestamp)v);
                            }
                            {
                                this.timestampFormat$1 = timestampFormat$1;
                            }
                        };
                    } else {
                        object = new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Object apply(Object v) {
                                return v;
                            }
                        };
                    }
                }
                return object;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Function1.class)));
        Accumulable nonEmptyPartitions = sqlContext.sparkContext().accumulableCollection((Object)HashSet$.MODULE$.empty(), (Function1)Predef$.MODULE$.conforms(), ClassTag$.MODULE$.apply(HashSet.class));
        RDD convertedRows = data.mapPartitions((Function1)new Serializable(this, conversionFunctions, nonEmptyPartitions){
            public static final long serialVersionUID = 0L;
            public final Function1[] conversionFunctions$1;
            private final Accumulable nonEmptyPartitions$1;

            public final Iterator<Row> apply(Iterator<Row> iter) {
                if (iter.hasNext()) {
                    this.nonEmptyPartitions$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)TaskContext$.MODULE$.get().partitionId()));
                }
                return iter.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$8 $outer;

                    public final Row apply(Row row) {
                        Object[] convertedValues = new Object[this.$outer.conversionFunctions$1.length];
                        for (int i = 0; i < this.$outer.conversionFunctions$1.length; ++i) {
                            convertedValues[i] = this.$outer.conversionFunctions$1[i].apply(row.apply(i));
                        }
                        return Row$.MODULE$.fromSeq((Seq)Predef$.MODULE$.genericWrapArray((Object)convertedValues));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.conversionFunctions$1 = conversionFunctions$1;
                this.nonEmptyPartitions$1 = nonEmptyPartitions$1;
            }
        }, ClassTag$.MODULE$.apply(Row.class));
        StructType schemaWithLowercaseColumnNames = StructType$.MODULE$.apply((Seq)data.schema().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final StructField apply(StructField f) {
                return f.copy(f.name().toLowerCase(), f.copy$default$2(), f.copy$default$3(), f.copy$default$4());
            }
        }, Seq$.MODULE$.canBuildFrom()));
        if (((TraversableOnce)schemaWithLowercaseColumnNames.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(StructField x$3) {
                return x$3.name();
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet().size() != data.schema().size()) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Cannot save table to Redshift because two or more column names would be identical after conversion to lowercase: ").append((Object)((TraversableOnce)data.schema().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(StructField x$4) {
                    return x$4.name();
                }
            }, Seq$.MODULE$.canBuildFrom())).mkString(", ")).toString());
        }
        StructType convertedSchema = StructType$.MODULE$.apply((Seq)schemaWithLowercaseColumnNames.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final StructField apply(StructField x0$1) {
                StructField structField = x0$1;
                if (structField != null) {
                    String name = structField.name();
                    DataType dataType = structField.dataType();
                    boolean nullable = structField.nullable();
                    Metadata meta = structField.metadata();
                    DateType$ dateType$ = DateType$.MODULE$;
                    DataType dataType2 = dataType;
                    if (dateType$ == null) {
                        if (dataType2 == null) return new StructField(name, (DataType)StringType$.MODULE$, nullable, meta);
                    } else if (dateType$.equals(dataType2)) {
                        return new StructField(name, (DataType)StringType$.MODULE$, nullable, meta);
                    }
                }
                if (structField == null) return structField;
                String name = structField.name();
                DataType dataType = structField.dataType();
                boolean nullable = structField.nullable();
                Metadata meta = structField.metadata();
                TimestampType$ timestampType$ = TimestampType$.MODULE$;
                DataType dataType3 = dataType;
                if (timestampType$ != null) {
                    if (!timestampType$.equals(dataType3)) return structField;
                    return new StructField(name, (DataType)StringType$.MODULE$, nullable, meta);
                }
                if (dataType3 == null) return new StructField(name, (DataType)StringType$.MODULE$, nullable, meta);
                return structField;
            }
        }, Seq$.MODULE$.canBuildFrom()));
        sqlContext.createDataFrame(convertedRows, convertedSchema).write().format("com.databricks.spark.avro").save(tempDir);
        if (((SetLike)nonEmptyPartitions.value()).isEmpty()) {
            none$ = None$.MODULE$;
            return none$;
        }
        FileSystem fs = FileSystem.get((URI)URI.create(tempDir), (Configuration)sqlContext.sparkContext().hadoopConfiguration());
        Regex partitionIdRegex = new StringOps(Predef$.MODULE$.augmentString("^part-(?:r-)?(\\d+)[^\\d+].*$")).r();
        Set nonEmptyPartitionIds = ((TraversableOnce)nonEmptyPartitions.value()).toSet();
        Seq filesToLoad = (Seq)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(new Path(tempDir))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(FileStatus x$5) {
                return x$5.getPath().getName();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).collect((PartialFunction)new Serializable(this, partitionIdRegex, nonEmptyPartitionIds){
            public static final long serialVersionUID = 0L;
            private final Regex partitionIdRegex$1;
            private final Set nonEmptyPartitionIds$1;

            public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                String id;
                A1 A1 = x1;
                Option option = this.partitionIdRegex$1.unapplySeq(A1);
                Object object = !option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0 && this.nonEmptyPartitionIds$1.contains((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(id = (String)((LinearSeqOptimized)option.get()).apply(0))).toInt())) ? A1 : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(String x1) {
                String id;
                String string = x1;
                Option option = this.partitionIdRegex$1.unapplySeq((Object)string);
                boolean bl = !option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0 && this.nonEmptyPartitionIds$1.contains((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(id = (String)((LinearSeqOptimized)option.get()).apply(0))).toInt()));
                return bl;
            }
            {
                this.partitionIdRegex$1 = partitionIdRegex$1;
                this.nonEmptyPartitionIds$1 = nonEmptyPartitionIds$1;
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        String sanitizedTempDir = new StringOps(Predef$.MODULE$.augmentString(Utils$.MODULE$.fixS3Url(Utils$.MODULE$.removeCredentialsFromURI(URI.create(tempDir)).toString()))).stripSuffix("/");
        Seq manifestEntries = (Seq)filesToLoad.map((Function1)new Serializable(this, sanitizedTempDir){
            public static final long serialVersionUID = 0L;
            private final String sanitizedTempDir$1;

            public final String apply(String file) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"url\":\"", "/", "\", \"mandatory\":true}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.sanitizedTempDir$1, file}));
            }
            {
                this.sanitizedTempDir$1 = sanitizedTempDir$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        String manifest = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"entries\": [", "]}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{manifestEntries.mkString(",\n")}));
        String manifestPath = new StringBuilder().append((Object)sanitizedTempDir).append((Object)"/manifest.json").toString();
        FSDataOutputStream fsDataOut = fs.create(new Path(manifestPath));
        try {
            fsDataOut.write(manifest.getBytes("utf-8"));
        }
        catch (Throwable throwable) {
            void var17_17;
            var17_17.close();
            throw throwable;
        }
        fsDataOut.close();
        none$ = new Some((Object)manifestPath);
        return none$;
    }

    public void saveToRedshift(SQLContext sqlContext, DataFrame data, SaveMode saveMode, Parameters.MergedParameters params) {
        if (params.table().isEmpty()) {
            throw new IllegalArgumentException("For save operations you must specify a Redshift table name with the 'dbtable' parameter");
        }
        if (!params.useStagingTable()) {
            this.com$databricks$spark$redshift$RedshiftWriter$$log().warn("Setting useStagingTable=false is deprecated; instead, we recommend that you drop the target table yourself. For more details on this deprecation, seehttps://github.com/databricks/spark-redshift/pull/157");
        }
        AWSCredentials creds = AWSCredentialsUtils$.MODULE$.load(params, sqlContext.sparkContext().hadoopConfiguration());
        Utils$.MODULE$.assertThatFileSystemIsNotS3BlockFileSystem(new URI(params.rootTempDir()), sqlContext.sparkContext().hadoopConfiguration());
        Utils$.MODULE$.checkThatBucketHasObjectLifecycleConfiguration(params.rootTempDir(), (AmazonS3Client)this.s3ClientFactory.apply((Object)creds));
        Option<String> manifestUrl = this.unloadData(sqlContext, data, params.createPerQueryTempDir());
        Connection conn = this.com$databricks$spark$redshift$RedshiftWriter$$jdbcWrapper.getConnector(params.jdbcDriver(), params.jdbcUrl(), params.credentials());
        conn.setAutoCommit(false);
        try {
            TableName table2 = (TableName)params.table().get();
            SaveMode saveMode2 = saveMode;
            SaveMode saveMode3 = SaveMode.Overwrite;
            if (!(saveMode2 != null ? !saveMode2.equals(saveMode3) : saveMode3 != null)) {
                this.com$databricks$spark$redshift$RedshiftWriter$$jdbcWrapper.executeInterruptibly(conn.prepareStatement(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DROP TABLE IF EXISTS ", ";"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table2}))));
                if (!params.useStagingTable()) {
                    conn.commit();
                }
            }
            this.com$databricks$spark$redshift$RedshiftWriter$$log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading new Redshift data to: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table2})));
            this.doRedshiftLoad(conn, data, params, creds, manifestUrl);
            conn.commit();
        }
        catch (Throwable throwable) {
            try {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                try {
                    this.com$databricks$spark$redshift$RedshiftWriter$$log().error("Exception thrown during Redshift load; will roll back transaction", e);
                    conn.rollback();
                }
                catch (Throwable throwable3) {
                    Throwable throwable4 = throwable3;
                    Option option2 = NonFatal$.MODULE$.unapply(throwable4);
                    if (option2.isEmpty()) {
                        throw throwable3;
                    }
                    Throwable e2 = (Throwable)option2.get();
                    this.com$databricks$spark$redshift$RedshiftWriter$$log().error("Exception while rolling back transaction", e2);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                throw e;
            }
            catch (Throwable throwable5) {
                conn.close();
                throw throwable5;
            }
        }
        conn.close();
    }

    public RedshiftWriter(JDBCWrapper jdbcWrapper, Function1<AWSCredentials, AmazonS3Client> s3ClientFactory) {
        this.com$databricks$spark$redshift$RedshiftWriter$$jdbcWrapper = jdbcWrapper;
        this.s3ClientFactory = s3ClientFactory;
        this.com$databricks$spark$redshift$RedshiftWriter$$log = LoggerFactory.getLogger(this.getClass());
    }
}

