/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.spark.redshift;

import com.databricks.spark.redshift.RedshiftInputFormat$;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Mf!B\u0001\u0003\u0001\tQ!\u0001\u0006*fIND\u0017N\u001a;SK\u000e|'\u000f\u001a*fC\u0012,'O\u0003\u0002\u0004\t\u0005A!/\u001a3tQ&4GO\u0003\u0002\u0006\r\u0005)1\u000f]1sW*\u0011q\u0001C\u0001\u000bI\u0006$\u0018M\u0019:jG.\u001c(\"A\u0005\u0002\u0007\r|Wn\u0005\u0002\u0001\u0017A!A\"F\f \u001b\u0005i!B\u0001\b\u0010\u0003%i\u0017\r\u001d:fIV\u001cWM\u0003\u0002\u0011#\u00051\u0001.\u00193p_BT!AE\n\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0012aA8sO&\u0011a#\u0004\u0002\r%\u0016\u001cwN\u001d3SK\u0006$WM\u001d\t\u00031ui\u0011!\u0007\u0006\u00035m\tA\u0001\\1oO*\tA$\u0001\u0003kCZ\f\u0017B\u0001\u0010\u001a\u0005\u0011auN\\4\u0011\u0007\u0001\u001aS%D\u0001\"\u0015\u0005\u0011\u0013!B:dC2\f\u0017B\u0001\u0013\"\u0005\u0015\t%O]1z!\t1\u0013F\u0004\u0002!O%\u0011\u0001&I\u0001\u0007!J,G-\u001a4\n\u0005)Z#AB*ue&twM\u0003\u0002)C!)Q\u0006\u0001C\u0001_\u00051A(\u001b8jiz\u001a\u0001\u0001F\u00011!\t\t\u0004!D\u0001\u0003\u0011%\u0019\u0004\u00011AA\u0002\u0013%A'\u0001\u0004sK\u0006$WM]\u000b\u0002kA\u0011a'O\u0007\u0002o)\u0011\u0001hG\u0001\u0003S>L!AO\u001c\u0003'\t+hMZ3sK\u0012Le\u000e];u'R\u0014X-Y7\t\u0013q\u0002\u0001\u0019!a\u0001\n\u0013i\u0014A\u0003:fC\u0012,'o\u0018\u0013fcR\u0011a(\u0011\t\u0003A}J!\u0001Q\u0011\u0003\tUs\u0017\u000e\u001e\u0005\b\u0005n\n\t\u00111\u00016\u0003\rAH%\r\u0005\u0007\t\u0002\u0001\u000b\u0015B\u001b\u0002\u000fI,\u0017\rZ3sA!Ia\t\u0001a\u0001\u0002\u0004%IaR\u0001\u0004W\u0016LX#A\f\t\u0013%\u0003\u0001\u0019!a\u0001\n\u0013Q\u0015aB6fs~#S-\u001d\u000b\u0003}-CqA\u0011%\u0002\u0002\u0003\u0007q\u0003\u0003\u0004N\u0001\u0001\u0006KaF\u0001\u0005W\u0016L\b\u0005C\u0005P\u0001\u0001\u0007\t\u0019!C\u0005!\u0006)a/\u00197vKV\tq\u0004C\u0005S\u0001\u0001\u0007\t\u0019!C\u0005'\u0006Ia/\u00197vK~#S-\u001d\u000b\u0003}QCqAQ)\u0002\u0002\u0003\u0007q\u0004\u0003\u0004W\u0001\u0001\u0006KaH\u0001\u0007m\u0006dW/\u001a\u0011\t\u0013a\u0003\u0001\u0019!a\u0001\n\u0013I\u0016!B:uCJ$X#\u0001.\u0011\u0005\u0001Z\u0016B\u0001\u0010\"\u0011%i\u0006\u00011AA\u0002\u0013%a,A\u0005ti\u0006\u0014Ho\u0018\u0013fcR\u0011ah\u0018\u0005\b\u0005r\u000b\t\u00111\u0001[\u0011\u0019\t\u0007\u0001)Q\u00055\u000611\u000f^1si\u0002B\u0011b\u0019\u0001A\u0002\u0003\u0007I\u0011B-\u0002\u0007\u0015tG\rC\u0005f\u0001\u0001\u0007\t\u0019!C\u0005M\u00069QM\u001c3`I\u0015\fHC\u0001 h\u0011\u001d\u0011E-!AA\u0002iCa!\u001b\u0001!B\u0013Q\u0016\u0001B3oI\u0002B\u0011b\u001b\u0001A\u0002\u0003\u0007I\u0011B-\u0002\u0007\r,(\u000fC\u0005n\u0001\u0001\u0007\t\u0019!C\u0005]\u000691-\u001e:`I\u0015\fHC\u0001 p\u0011\u001d\u0011E.!AA\u0002iCa!\u001d\u0001!B\u0013Q\u0016\u0001B2ve\u0002Bqa\u001d\u0001A\u0002\u0013%A/A\u0002f_\u001a,\u0012!\u001e\t\u0003AYL!a^\u0011\u0003\u000f\t{w\u000e\\3b]\"9\u0011\u0010\u0001a\u0001\n\u0013Q\u0018aB3pM~#S-\u001d\u000b\u0003}mDqA\u0011=\u0002\u0002\u0003\u0007Q\u000f\u0003\u0004~\u0001\u0001\u0006K!^\u0001\u0005K>4\u0007\u0005\u0003\u0006\u0000\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0003\t\u0011\u0002Z3mS6LG/\u001a:\u0016\u0005\u0005\r\u0001c\u0001\u0011\u0002\u0006%\u0019\u0011qA\u0011\u0003\t\tKH/\u001a\u0005\f\u0003\u0017\u0001\u0001\u0019!a\u0001\n\u0013\ti!A\u0007eK2LW.\u001b;fe~#S-\u001d\u000b\u0004}\u0005=\u0001\"\u0003\"\u0002\n\u0005\u0005\t\u0019AA\u0002\u0011!\t\u0019\u0002\u0001Q!\n\u0005\r\u0011A\u00033fY&l\u0017\u000e^3sA!A\u0011q\u0003\u0001!\u0002\u001b\t\u0019!\u0001\u0006fg\u000e\f\u0007/Z\"iCJDC!!\u0006\u0002\u001cA\u0019\u0001%!\b\n\u0007\u0005}\u0011E\u0001\u0004j]2Lg.\u001a\u0005\t\u0003G\u0001\u0001\u0015!\u0004\u0002\u0004\u0005AA.\u001b8f\r\u0016,G\r\u000b\u0003\u0002\"\u0005m\u0001\u0002CA\u0015\u0001\u0001\u0006i!a\u0001\u0002\u001d\r\f'O]5bO\u0016\u0014V\r^;s]\"\"\u0011qEA\u000e\u0011!\ty\u0003\u0001Q\u0001\u000e\u0005E\u0012!\u00053fM\u0006,H\u000e\u001e\"vM\u001a,'oU5{K>\u0011\u00111G\u000f\u0004!\u0001\u0001\u0001\u0006BA\u0017\u00037A\u0001\"!\u000f\u0001A\u0003%\u00111H\u0001\u0006G\"\f'o\u001d\t\u0007\u0003{\t9%a\u0001\u000e\u0005\u0005}\"\u0002BA!\u0003\u0007\nq!\\;uC\ndWMC\u0002\u0002F\u0005\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI%a\u0010\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\u0005\b\u0003\u001b\u0002A\u0011IA(\u0003)Ig.\u001b;jC2L'0\u001a\u000b\u0006}\u0005E\u00131\f\u0005\t\u0003'\nY\u00051\u0001\u0002V\u0005Q\u0011N\u001c9viN\u0003H.\u001b;\u0011\u00071\t9&C\u0002\u0002Z5\u0011!\"\u00138qkR\u001c\u0006\u000f\\5u\u0011!\ti&a\u0013A\u0002\u0005}\u0013aB2p]R,\u0007\u0010\u001e\t\u0004\u0019\u0005\u0005\u0014bAA2\u001b\t\u0011B+Y:l\u0003R$X-\u001c9u\u0007>tG/\u001a=u\u0011\u001d\t9\u0007\u0001C!\u0003S\n1bZ3u!J|wM]3tgR\u0011\u00111\u000e\t\u0004A\u00055\u0014bAA8C\t)a\t\\8bi\"9\u00111\u000f\u0001\u0005B\u0005U\u0014\u0001\u00048fqR\\U-\u001f,bYV,G#A;\t\u000f\u0005e\u0004\u0001\"\u0011\u0002|\u0005yq-\u001a;DkJ\u0014XM\u001c;WC2,X\rF\u0001 \u0011\u001d\ty\b\u0001C!\u0003\u0003\u000bQbZ3u\u0007V\u0014(/\u001a8u\u0017\u0016LH#A\f\t\u000f\u0005\u0015\u0005\u0001\"\u0011\u0002\b\u0006)1\r\\8tKR\ta\bC\u0004\u0002\f\u0002!I!!$\u0002\u0011\u0019Lg\u000e\u001a(fqR$\u0012BWAH\u0003;\u000b9+a+\t\u0011\u0005E\u0015\u0011\u0012a\u0001\u0003'\u000b!AZ:\u0011\t\u0005U\u0015\u0011T\u0007\u0003\u0003/S1!!%\u0010\u0013\u0011\tY*a&\u0003\u0015\u0019KG.Z*zgR,W\u000e\u0003\u0005\u0002 \u0006%\u0005\u0019AAQ\u0003\u00111\u0017\u000e\\3\u0011\t\u0005U\u00151U\u0005\u0005\u0003K\u000b9J\u0001\u0003QCRD\u0007bBAU\u0003\u0013\u0003\rAW\u0001\u0005g&TX\rC\u0004\u0002.\u0006%\u0005\u0019\u0001.\u0002\r=4gm]3u\u0011\u001d\t\t\f\u0001C\u0005\u0003w\n\u0011B\\3yiZ\u000bG.^3")
public class RedshiftRecordReader
extends RecordReader<Long, String[]> {
    private BufferedInputStream reader;
    private Long key;
    private String[] value;
    private long start;
    private long end;
    private long cur;
    private boolean eof = false;
    private byte com$databricks$spark$redshift$RedshiftRecordReader$$delimiter;
    private final byte escapeChar = (byte)92;
    private final byte lineFeed = (byte)10;
    private final byte carriageReturn = (byte)13;
    private final int defaultBufferSize;
    private final ArrayBuffer<Object> chars = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();

    private BufferedInputStream reader() {
        return this.reader;
    }

    private void reader_$eq(BufferedInputStream x$1) {
        this.reader = x$1;
    }

    private Long key() {
        return this.key;
    }

    private void key_$eq(Long x$1) {
        this.key = x$1;
    }

    private String[] value() {
        return this.value;
    }

    private void value_$eq(String[] x$1) {
        this.value = x$1;
    }

    private long start() {
        return this.start;
    }

    private void start_$eq(long x$1) {
        this.start = x$1;
    }

    private long end() {
        return this.end;
    }

    private void end_$eq(long x$1) {
        this.end = x$1;
    }

    private long cur() {
        return this.cur;
    }

    private void cur_$eq(long x$1) {
        this.cur = x$1;
    }

    private boolean eof() {
        return this.eof;
    }

    private void eof_$eq(boolean x$1) {
        this.eof = x$1;
    }

    public byte com$databricks$spark$redshift$RedshiftRecordReader$$delimiter() {
        return this.com$databricks$spark$redshift$RedshiftRecordReader$$delimiter;
    }

    private void com$databricks$spark$redshift$RedshiftRecordReader$$delimiter_$eq(byte x$1) {
        this.com$databricks$spark$redshift$RedshiftRecordReader$$delimiter = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public void initialize(InputSplit inputSplit, TaskAttemptContext context) {
        void var4_4;
        FileSplit split = (FileSplit)inputSplit;
        Path file = split.getPath();
        Method method = context.getClass().getMethod("getConfiguration", new Class[0]);
        Configuration conf = (Configuration)method.invoke((Object)context, new Object[0]);
        this.com$databricks$spark$redshift$RedshiftRecordReader$$delimiter_$eq((byte)RedshiftInputFormat$.MODULE$.getDelimiterOrDefault(conf));
        Predef$.MODULE$.require(this.com$databricks$spark$redshift$RedshiftRecordReader$$delimiter() != this.escapeChar, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RedshiftRecordReader $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The delimiter and the escape char cannot be the same but found ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)this.$outer.com$databricks$spark$redshift$RedshiftRecordReader$$delimiter())}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        Predef$.MODULE$.require(this.com$databricks$spark$redshift$RedshiftRecordReader$$delimiter() != this.lineFeed, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The delimiter cannot be the lineFeed character.";
            }
        });
        Predef$.MODULE$.require(this.com$databricks$spark$redshift$RedshiftRecordReader$$delimiter() != this.carriageReturn, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The delimiter cannot be the carriage return.";
            }
        });
        CompressionCodecFactory compressionCodecs = new CompressionCodecFactory(conf);
        CompressionCodec codec = compressionCodecs.getCodec(file);
        if (codec == null) {
            Object object;
            FileSystem fs = file.getFileSystem(conf);
            long size = fs.getFileStatus(file).getLen();
            this.start_$eq(this.findNext(fs, file, size, split.getStart()));
            this.end_$eq(this.findNext(fs, file, size, split.getStart() + split.getLength()));
            this.cur_$eq(this.start());
            FSDataInputStream in = fs.open(file);
            if (this.cur() > 0L) {
                in.seek(this.cur() - 1L);
                object = BoxesRunTime.boxToInteger((int)in.read());
            } else {
                object = BoxedUnit.UNIT;
            }
            this.reader_$eq(new BufferedInputStream((InputStream)in, 0x100000));
            return;
        }
        throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Do not support compressed files but found ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var4_4})));
    }

    public float getProgress() {
        return this.start() >= this.end() ? 1.0f : package$.MODULE$.min((float)(this.cur() - this.start()) / (float)(this.end() - this.start()), 1.0f);
    }

    public boolean nextKeyValue() {
        boolean bl;
        if (this.cur() < this.end() && !this.eof()) {
            this.key_$eq(Predef$.MODULE$.long2Long(this.cur()));
            this.value_$eq(this.nextValue());
            bl = true;
        } else {
            this.key_$eq(null);
            this.value_$eq(null);
            bl = false;
        }
        return bl;
    }

    public String[] getCurrentValue() {
        return this.value();
    }

    public Long getCurrentKey() {
        return this.key();
    }

    public void close() {
        if (this.reader() != null) {
            this.reader().close();
        }
    }

    /*
     * WARNING - void declaration
     */
    private long findNext(FileSystem fs, Path file, long size, long offset) {
        if (offset == 0L) {
            return 0L;
        }
        if (offset >= size) {
            return size;
        }
        FSDataInputStream in = fs.open(file);
        long pos = offset;
        in.seek(pos);
        BufferedInputStream bis = new BufferedInputStream((InputStream)in, 0x100000);
        boolean escaped = true;
        boolean thisEof = false;
        while (escaped && !thisEof) {
            int v = bis.read();
            if (v < 0) {
                thisEof = true;
                continue;
            }
            ++pos;
            if (v == this.escapeChar) continue;
            escaped = false;
        }
        boolean endOfRecord = false;
        while (true) {
            boolean bl;
            void var8_6;
            void var10_7;
            if (!escaped && endOfRecord || thisEof) {
                in.close();
                return pos;
            }
            int v = var10_7.read();
            if (v < 0) {
                boolean bl2 = true;
                continue;
            }
            ++var8_6;
            if (v == this.escapeChar) {
                bl = true;
                continue;
            }
            if (bl) {
                bl = false;
                continue;
            }
            boolean bl3 = v == this.lineFeed;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String[] nextValue() {
        ArrayBuffer fields = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        boolean escaped = false;
        boolean endOfRecord = false;
        block0: while (true) {
            if (endOfRecord || this.eof()) {
                if (escaped) {
                    throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found hanging escape char."})).s((Seq)Nil$.MODULE$));
                }
                return (String[])fields.toArray(ClassTag$.MODULE$.apply(String.class));
            }
            boolean endOfField = false;
            this.chars.clear();
            while (true) {
                boolean bl;
                boolean bl2;
                if (endOfField || bl2 || this.eof()) {
                    void var1_1;
                    var1_1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new String((byte[])this.chars.toArray(ClassTag$.MODULE$.Byte()), Charset.forName("UTF-8"))}));
                    continue block0;
                }
                int v = this.reader().read();
                if (v < 0) {
                    this.eof_$eq(true);
                    continue;
                }
                this.cur_$eq(this.cur() + 1L);
                byte c = (byte)v;
                if (bl) {
                    if (c != this.escapeChar && c != this.com$databricks$spark$redshift$RedshiftRecordReader$$delimiter() && c != this.lineFeed && c != this.carriageReturn) {
                        throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found `", "` (ASCII ", ") after ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)c), BoxesRunTime.boxToInteger((int)v), BoxesRunTime.boxToByte((byte)this.escapeChar)})));
                    }
                    this.chars.append((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{c}));
                    bl = false;
                    continue;
                }
                if (c == this.escapeChar) {
                    bl = true;
                    continue;
                }
                if (c == this.com$databricks$spark$redshift$RedshiftRecordReader$$delimiter()) {
                    boolean bl3 = true;
                    continue;
                }
                if (c == this.lineFeed) {
                    bl2 = true;
                    continue;
                }
                this.chars.append((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{c}));
            }
            break;
        }
    }
}

