package com.databricks.sdk.core.error.details;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ErrorInfo extends ErrorInfo {

  private final String reason;

  private final String domain;

  private final Map<String, String> metadata;

  private AutoValue_ErrorInfo(
      String reason,
      String domain,
      Map<String, String> metadata) {
    this.reason = reason;
    this.domain = domain;
    this.metadata = metadata;
  }

  @JsonProperty("reason")
  @Override
  public String reason() {
    return reason;
  }

  @JsonProperty("domain")
  @Override
  public String domain() {
    return domain;
  }

  @JsonProperty("metadata")
  @Override
  public Map<String, String> metadata() {
    return metadata;
  }

  @Override
  public String toString() {
    return "ErrorInfo{"
        + "reason=" + reason + ", "
        + "domain=" + domain + ", "
        + "metadata=" + metadata
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ErrorInfo) {
      ErrorInfo that = (ErrorInfo) o;
      return this.reason.equals(that.reason())
          && this.domain.equals(that.domain())
          && this.metadata.equals(that.metadata());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= reason.hashCode();
    h$ *= 1000003;
    h$ ^= domain.hashCode();
    h$ *= 1000003;
    h$ ^= metadata.hashCode();
    return h$;
  }

  static final class Builder extends ErrorInfo.Builder {
    private String reason;
    private String domain;
    private Map<String, String> metadata;
    Builder() {
    }
    @Override
    public ErrorInfo.Builder setReason(String reason) {
      if (reason == null) {
        throw new NullPointerException("Null reason");
      }
      this.reason = reason;
      return this;
    }
    @Override
    public ErrorInfo.Builder setDomain(String domain) {
      if (domain == null) {
        throw new NullPointerException("Null domain");
      }
      this.domain = domain;
      return this;
    }
    @Override
    public ErrorInfo.Builder setMetadata(Map<String, String> metadata) {
      if (metadata == null) {
        throw new NullPointerException("Null metadata");
      }
      this.metadata = metadata;
      return this;
    }
    @Override
    public ErrorInfo build() {
      if (this.reason == null
          || this.domain == null
          || this.metadata == null) {
        StringBuilder missing = new StringBuilder();
        if (this.reason == null) {
          missing.append(" reason");
        }
        if (this.domain == null) {
          missing.append(" domain");
        }
        if (this.metadata == null) {
          missing.append(" metadata");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ErrorInfo(
          this.reason,
          this.domain,
          this.metadata);
    }
  }

}
