/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.model.core;

import com.databricks.jdbc.common.util.DatabricksTypeUtil;

public class ResultColumn {
    private final String columnName;
    private final String resultSetColumnName;
    private final Integer columnType;

    public ResultColumn(String columnName, String resultSetColumnName, Integer columnType) {
        this.columnName = columnName;
        this.resultSetColumnName = resultSetColumnName;
        this.columnType = columnType;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getResultSetColumnName() {
        return this.resultSetColumnName;
    }

    public Integer getColumnTypeInt() {
        return this.columnType;
    }

    public String getColumnTypeString() {
        if (this.columnType.equals(12)) {
            return "VARCHAR";
        }
        if (this.columnType.equals(5)) {
            return "SMALLINT";
        }
        if (this.columnType.equals(-7)) {
            return "BIT";
        }
        return "INTEGER";
    }

    public Integer getColumnPrecision() {
        return DatabricksTypeUtil.getMetadataColPrecision(this.columnType);
    }

    public Integer getColumnScale() {
        return DatabricksTypeUtil.getScale(this.columnType);
    }
}

