/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl.batch;

import com.databricks.internal.google.common.base.MoreObjects;
import com.databricks.internal.google.errorprone.annotations.CanIgnoreReturnValue;
import com.databricks.jdbc.api.impl.batch.BatchCommand;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="BatchCommand", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableBatchCommand
implements BatchCommand {
    private final String sql;

    private ImmutableBatchCommand(String sql) {
        this.sql = sql;
    }

    @Override
    public String getSql() {
        return this.sql;
    }

    public final ImmutableBatchCommand withSql(String value) {
        String newValue = Objects.requireNonNull(value, "sql");
        if (this.sql.equals(newValue)) {
            return this;
        }
        return new ImmutableBatchCommand(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBatchCommand && this.equalTo(0, (ImmutableBatchCommand)another);
    }

    private boolean equalTo(int synthetic, ImmutableBatchCommand another) {
        return this.sql.equals(another.sql);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.sql.hashCode();
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("BatchCommand").omitNullValues().add("sql", this.sql).toString();
    }

    public static ImmutableBatchCommand copyOf(BatchCommand instance) {
        if (instance instanceof ImmutableBatchCommand) {
            return (ImmutableBatchCommand)instance;
        }
        return ImmutableBatchCommand.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="BatchCommand", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SQL = 1L;
        private long initBits = 1L;
        @Nullable
        private String sql;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(BatchCommand instance) {
            Objects.requireNonNull(instance, "instance");
            this.sql(instance.getSql());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sql(String sql) {
            this.sql = Objects.requireNonNull(sql, "sql");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableBatchCommand build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBatchCommand(this.sql);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("sql");
            }
            return "Cannot build BatchCommand, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

