/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl.arrow;

import com.databricks.internal.apache.arrow.vector.types.pojo.ArrowType;
import com.databricks.internal.apache.arrow.vector.types.pojo.Field;
import com.databricks.internal.apache.arrow.vector.types.pojo.FieldType;
import com.databricks.internal.apache.arrow.vector.types.pojo.Schema;
import com.databricks.internal.apache.arrow.vector.util.SchemaUtility;
import com.databricks.internal.google.common.annotations.VisibleForTesting;
import com.databricks.jdbc.api.impl.arrow.ArrowResultChunk;
import com.databricks.jdbc.api.impl.arrow.ChunkProvider;
import com.databricks.jdbc.api.internal.IDatabricksSession;
import com.databricks.jdbc.api.internal.IDatabricksStatementInternal;
import com.databricks.jdbc.common.CompressionCodec;
import com.databricks.jdbc.common.util.DatabricksTypeUtil;
import com.databricks.jdbc.common.util.DecompressionUtil;
import com.databricks.jdbc.exception.DatabricksParsingException;
import com.databricks.jdbc.exception.DatabricksSQLException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import com.databricks.jdbc.model.client.thrift.generated.TColumnDesc;
import com.databricks.jdbc.model.client.thrift.generated.TFetchResultsResp;
import com.databricks.jdbc.model.client.thrift.generated.TGetResultSetMetadataResp;
import com.databricks.jdbc.model.client.thrift.generated.TPrimitiveTypeEntry;
import com.databricks.jdbc.model.client.thrift.generated.TSparkArrowBatch;
import com.databricks.jdbc.model.client.thrift.generated.TTableSchema;
import com.databricks.jdbc.model.core.ResultData;
import com.databricks.jdbc.model.core.ResultManifest;
import com.databricks.jdbc.model.telemetry.enums.DatabricksDriverErrorCode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class InlineChunkProvider
implements ChunkProvider {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(InlineChunkProvider.class);
    private long totalRows;
    private long currentChunkIndex = -1L;
    private boolean isClosed;
    private final ArrowResultChunk arrowResultChunk;

    InlineChunkProvider(TFetchResultsResp resultsResp, IDatabricksStatementInternal parentStatement, IDatabricksSession session) throws DatabricksParsingException {
        this.totalRows = 0L;
        ByteArrayInputStream byteStream = this.initializeByteStream(resultsResp, session, parentStatement);
        ArrowResultChunk.Builder builder = ArrowResultChunk.builder().withInputStream(byteStream, this.totalRows);
        if (parentStatement != null) {
            builder.withStatementId(parentStatement.getStatementId());
        }
        this.arrowResultChunk = builder.build();
    }

    InlineChunkProvider(ResultData resultData, ResultManifest resultManifest) throws DatabricksSQLException {
        this.totalRows = resultManifest.getTotalRowCount();
        CompressionCodec compressionType = resultManifest.getResultCompression();
        byte[] decompressedBytes = DecompressionUtil.decompress(resultData.getAttachment(), compressionType, "Data fetch for inline arrow batch with decompression algorithm : " + String.valueOf((Object)compressionType));
        this.arrowResultChunk = ArrowResultChunk.builder().withInputStream(new ByteArrayInputStream(decompressedBytes), this.totalRows).build();
    }

    @Override
    public boolean hasNextChunk() {
        return this.currentChunkIndex == -1L;
    }

    @Override
    public boolean next() {
        if (!this.hasNextChunk()) {
            return false;
        }
        ++this.currentChunkIndex;
        return true;
    }

    @Override
    public ArrowResultChunk getChunk() {
        return this.arrowResultChunk;
    }

    @Override
    public void close() {
        this.isClosed = true;
        this.arrowResultChunk.releaseChunk();
    }

    @Override
    public long getRowCount() {
        return this.totalRows;
    }

    @Override
    public long getChunkCount() {
        return 0L;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    private ByteArrayInputStream initializeByteStream(TFetchResultsResp resultsResp, IDatabricksSession session, IDatabricksStatementInternal parentStatement) throws DatabricksParsingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CompressionCodec compressionType = CompressionCodec.getCompressionMapping(resultsResp.getResultSetMetadata());
        try {
            byte[] serializedSchema = this.getSerializedSchema(resultsResp.getResultSetMetadata());
            if (serializedSchema != null) {
                baos.write(serializedSchema);
            }
            this.writeToByteOutputStream(compressionType, parentStatement, resultsResp.getResults().getArrowBatches(), baos);
            while (resultsResp.hasMoreRows) {
                resultsResp = session.getDatabricksClient().getMoreResults(parentStatement);
                this.writeToByteOutputStream(compressionType, parentStatement, resultsResp.getResults().getArrowBatches(), baos);
            }
            return new ByteArrayInputStream(baos.toByteArray());
        }
        catch (DatabricksSQLException | IOException e) {
            this.handleError(e);
            return null;
        }
    }

    private void writeToByteOutputStream(CompressionCodec compressionCodec, IDatabricksStatementInternal parentStatement, List<TSparkArrowBatch> arrowBatchList, ByteArrayOutputStream baos) throws DatabricksSQLException, IOException {
        for (TSparkArrowBatch arrowBatch : arrowBatchList) {
            byte[] decompressedBytes = DecompressionUtil.decompress(arrowBatch.getBatch(), compressionCodec, String.format("Data fetch for inline arrow batch [%d] and statement [%s] with decompression algorithm : [%s]", new Object[]{arrowBatch.getRowCount(), parentStatement, compressionCodec}));
            this.totalRows += arrowBatch.getRowCount();
            baos.write(decompressedBytes);
        }
    }

    private byte[] getSerializedSchema(TGetResultSetMetadataResp metadata) throws DatabricksSQLException {
        if (metadata.getArrowSchema() != null) {
            return metadata.getArrowSchema();
        }
        Schema arrowSchema = this.hiveSchemaToArrowSchema(metadata.getSchema());
        try {
            return SchemaUtility.serialize(arrowSchema);
        }
        catch (IOException e) {
            this.handleError(e);
            return null;
        }
    }

    private Schema hiveSchemaToArrowSchema(TTableSchema hiveSchema) throws DatabricksParsingException {
        ArrayList<Field> fields = new ArrayList<Field>();
        if (hiveSchema == null) {
            return new Schema(fields);
        }
        try {
            hiveSchema.getColumns().forEach(columnDesc -> {
                try {
                    fields.add(this.getArrowField((TColumnDesc)columnDesc));
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (RuntimeException e) {
            this.handleError(e);
        }
        return new Schema(fields);
    }

    private Field getArrowField(TColumnDesc columnDesc) throws SQLException {
        TPrimitiveTypeEntry primitiveTypeEntry = DatabricksTypeUtil.getTPrimitiveTypeOrDefault(columnDesc.getTypeDesc());
        ArrowType arrowType = DatabricksTypeUtil.mapThriftToArrowType(primitiveTypeEntry.getType());
        FieldType fieldType = new FieldType(true, arrowType, null);
        return new Field(columnDesc.getColumnName(), fieldType, null);
    }

    @VisibleForTesting
    void handleError(Exception e) throws DatabricksParsingException {
        String errorMessage = String.format("Cannot process inline arrow format. Error: %s", e.getMessage());
        LOGGER.error(errorMessage);
        throw new DatabricksParsingException(errorMessage, (Throwable)e, DatabricksDriverErrorCode.INLINE_CHUNK_PARSING_ERROR);
    }
}

