/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl;

import com.databricks.jdbc.exception.DatabricksDriverException;
import com.databricks.jdbc.model.telemetry.enums.DatabricksDriverErrorCode;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class MetadataParser {
    public static Map<String, String> parseStructMetadata(String metadata) {
        String[] fields;
        LinkedHashMap<String, String> typeMap = new LinkedHashMap<String, String>();
        metadata = metadata.substring("STRUCT<".length(), metadata.length() - 1);
        for (String field : fields = MetadataParser.splitFields(metadata)) {
            String[] parts = field.split(":", 2);
            String fieldName = parts[0].trim();
            String fieldType = MetadataParser.cleanTypeName(parts[1].trim());
            if (fieldType.startsWith("STRUCT")) {
                typeMap.put(fieldName, fieldType);
                continue;
            }
            if (fieldType.startsWith("ARRAY")) {
                typeMap.put(fieldName, "ARRAY<" + MetadataParser.parseArrayMetadata(fieldType) + ">");
                continue;
            }
            if (fieldType.startsWith("MAP")) {
                typeMap.put(fieldName, "MAP<" + MetadataParser.parseMapMetadata(fieldType) + ">");
                continue;
            }
            typeMap.put(fieldName, fieldType);
        }
        return typeMap;
    }

    public static String parseArrayMetadata(String metadata) {
        return MetadataParser.cleanTypeName(metadata.substring("ARRAY<".length(), metadata.length() - 1).trim());
    }

    public static String parseMapMetadata(String metadata) {
        metadata = metadata.substring("MAP<".length(), metadata.length() - 1).trim();
        int depth = 0;
        int splitIndex = -1;
        for (int i = 0; i < metadata.length(); ++i) {
            char ch = metadata.charAt(i);
            if (ch == '<') {
                ++depth;
            } else if (ch == '>') {
                --depth;
            }
            if (ch != ',' || depth != 0) continue;
            splitIndex = i;
            break;
        }
        if (splitIndex == -1) {
            throw new DatabricksDriverException("Invalid MAP metadata: " + metadata, DatabricksDriverErrorCode.COMPLEX_DATA_TYPE_MAP_CONVERSION_ERROR);
        }
        String keyType = MetadataParser.cleanTypeName(metadata.substring(0, splitIndex).trim());
        String valueType = MetadataParser.cleanTypeName(metadata.substring(splitIndex + 1).trim());
        return keyType + ", " + valueType;
    }

    private static String[] splitFields(String metadata) {
        int angleBracketDepth = 0;
        int parenDepth = 0;
        StringBuilder currentField = new StringBuilder();
        ArrayList<String> fields = new ArrayList<String>();
        for (char ch : metadata.toCharArray()) {
            if (ch == '<') {
                ++angleBracketDepth;
            } else if (ch == '>') {
                --angleBracketDepth;
            } else if (ch == '(') {
                ++parenDepth;
            } else if (ch == ')') {
                --parenDepth;
            }
            if (ch == ',' && angleBracketDepth == 0 && parenDepth == 0) {
                String field = currentField.toString().trim();
                fields.add(field);
                currentField.setLength(0);
                continue;
            }
            currentField.append(ch);
        }
        String finalField = currentField.toString().trim();
        fields.add(finalField);
        return fields.toArray(new String[0]);
    }

    private static String cleanTypeName(String typeName) {
        return typeName.replaceAll(" NOT NULL", "").trim();
    }
}

