/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.iam;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.iam.DeleteServicePrincipalRequest;
import com.databricks.internal.sdk.service.iam.GetServicePrincipalRequest;
import com.databricks.internal.sdk.service.iam.ListServicePrincipalResponse;
import com.databricks.internal.sdk.service.iam.ListServicePrincipalsRequest;
import com.databricks.internal.sdk.service.iam.PartialUpdate;
import com.databricks.internal.sdk.service.iam.ServicePrincipal;
import com.databricks.internal.sdk.service.iam.ServicePrincipalsImpl;
import com.databricks.internal.sdk.service.iam.ServicePrincipalsService;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import com.databricks.internal.slf4j.Logger;
import com.databricks.internal.slf4j.LoggerFactory;

@Generated
public class ServicePrincipalsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(ServicePrincipalsAPI.class);
    private final ServicePrincipalsService impl;

    public ServicePrincipalsAPI(ApiClient apiClient) {
        this.impl = new ServicePrincipalsImpl(apiClient);
    }

    public ServicePrincipalsAPI(ServicePrincipalsService mock) {
        this.impl = mock;
    }

    public ServicePrincipal create(ServicePrincipal request) {
        return this.impl.create(request);
    }

    public void delete(String id) {
        this.delete(new DeleteServicePrincipalRequest().setId(id));
    }

    public void delete(DeleteServicePrincipalRequest request) {
        this.impl.delete(request);
    }

    public ServicePrincipal get(String id) {
        return this.get(new GetServicePrincipalRequest().setId(id));
    }

    public ServicePrincipal get(GetServicePrincipalRequest request) {
        return this.impl.get(request);
    }

    public Iterable<ServicePrincipal> list(ListServicePrincipalsRequest request) {
        request.setStartIndex(1L);
        if (request.getCount() == null) {
            request.setCount(10000L);
        }
        return new Paginator<ListServicePrincipalsRequest, ListServicePrincipalResponse, ServicePrincipal>(request, this.impl::list, ListServicePrincipalResponse::getResources, response -> {
            Long offset = request.getStartIndex();
            if (offset == null) {
                offset = 0L;
            }
            offset = offset + (long)response.getResources().size();
            return request.setStartIndex(offset);
        }).withDedupe(ServicePrincipal::getId);
    }

    public void patch(PartialUpdate request) {
        this.impl.patch(request);
    }

    public void update(ServicePrincipal request) {
        this.impl.update(request);
    }

    public ServicePrincipalsService impl() {
        return this.impl;
    }
}

