/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.catalog;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.http.Request;
import com.databricks.internal.sdk.service.catalog.CancelRefreshRequest;
import com.databricks.internal.sdk.service.catalog.CreateMonitor;
import com.databricks.internal.sdk.service.catalog.DeleteMonitorResponse;
import com.databricks.internal.sdk.service.catalog.DeleteQualityMonitorRequest;
import com.databricks.internal.sdk.service.catalog.GetQualityMonitorRequest;
import com.databricks.internal.sdk.service.catalog.GetRefreshRequest;
import com.databricks.internal.sdk.service.catalog.ListRefreshesRequest;
import com.databricks.internal.sdk.service.catalog.MonitorInfo;
import com.databricks.internal.sdk.service.catalog.MonitorRefreshInfo;
import com.databricks.internal.sdk.service.catalog.MonitorRefreshListResponse;
import com.databricks.internal.sdk.service.catalog.QualityMonitorsService;
import com.databricks.internal.sdk.service.catalog.RegenerateDashboardRequest;
import com.databricks.internal.sdk.service.catalog.RegenerateDashboardResponse;
import com.databricks.internal.sdk.service.catalog.RunRefreshRequest;
import com.databricks.internal.sdk.service.catalog.UpdateMonitor;
import com.databricks.internal.sdk.support.Generated;
import java.io.IOException;

@Generated
class QualityMonitorsImpl
implements QualityMonitorsService {
    private final ApiClient apiClient;

    public QualityMonitorsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public void cancelRefresh(CancelRefreshRequest request) {
        String path = String.format("/api/2.1/unity-catalog/tables/%s/monitor/refreshes/%s/cancel", request.getTableName(), request.getRefreshId());
        try {
            Request req = new Request("POST", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public MonitorInfo create(CreateMonitor request) {
        String path = String.format("/api/2.1/unity-catalog/tables/%s/monitor", request.getTableName());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, MonitorInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public DeleteMonitorResponse delete(DeleteQualityMonitorRequest request) {
        String path = String.format("/api/2.1/unity-catalog/tables/%s/monitor", request.getTableName());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, DeleteMonitorResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public MonitorInfo get(GetQualityMonitorRequest request) {
        String path = String.format("/api/2.1/unity-catalog/tables/%s/monitor", request.getTableName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, MonitorInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public MonitorRefreshInfo getRefresh(GetRefreshRequest request) {
        String path = String.format("/api/2.1/unity-catalog/tables/%s/monitor/refreshes/%s", request.getTableName(), request.getRefreshId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, MonitorRefreshInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public MonitorRefreshListResponse listRefreshes(ListRefreshesRequest request) {
        String path = String.format("/api/2.1/unity-catalog/tables/%s/monitor/refreshes", request.getTableName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, MonitorRefreshListResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public RegenerateDashboardResponse regenerateDashboard(RegenerateDashboardRequest request) {
        String path = String.format("/api/2.1/quality-monitoring/tables/%s/monitor/dashboard", request.getTableName());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, RegenerateDashboardResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public MonitorRefreshInfo runRefresh(RunRefreshRequest request) {
        String path = String.format("/api/2.1/unity-catalog/tables/%s/monitor/refreshes", request.getTableName());
        try {
            Request req = new Request("POST", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, MonitorRefreshInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public MonitorInfo update(UpdateMonitor request) {
        String path = String.format("/api/2.1/unity-catalog/tables/%s/monitor", request.getTableName());
        try {
            Request req = new Request("PUT", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, MonitorInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

