/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.operation.overlayng;

import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.geom.CoordinateList;
import com.databricks.internal.jts.geom.GeometryFactory;
import com.databricks.internal.jts.geom.TopologyException;
import com.databricks.internal.jts.io.WKTWriter;
import com.databricks.internal.jts.operation.overlayng.OverlayEdge;
import com.databricks.internal.jts.operation.overlayng.OverlayEdgeRing;
import com.databricks.internal.jts.util.Assert;
import java.util.ArrayList;
import java.util.List;

class MaximalEdgeRing {
    private static final int STATE_FIND_INCOMING = 1;
    private static final int STATE_LINK_OUTGOING = 2;
    private OverlayEdge startEdge;

    public static void linkResultAreaMaxRingAtNode(OverlayEdge nodeEdge) {
        OverlayEdge endOut;
        Assert.isTrue(nodeEdge.isInResultArea(), "Attempt to link non-result edge");
        OverlayEdge currOut = endOut = nodeEdge.oNextOE();
        int state = 1;
        OverlayEdge currResultIn = null;
        block4: do {
            if (currResultIn != null && currResultIn.isResultMaxLinked()) {
                return;
            }
            switch (state) {
                case 1: {
                    OverlayEdge currIn = currOut.symOE();
                    if (!currIn.isInResultArea()) continue block4;
                    currResultIn = currIn;
                    state = 2;
                    break;
                }
                case 2: {
                    if (!currOut.isInResultArea()) continue block4;
                    currResultIn.setNextResultMax(currOut);
                    state = 1;
                }
            }
        } while ((currOut = currOut.oNextOE()) != endOut);
        if (state == 2) {
            throw new TopologyException("no outgoing edge found", nodeEdge.getCoordinate());
        }
    }

    public MaximalEdgeRing(OverlayEdge e) {
        this.startEdge = e;
        this.attachEdges(e);
    }

    private void attachEdges(OverlayEdge startEdge) {
        OverlayEdge edge = startEdge;
        do {
            if (edge == null) {
                throw new TopologyException("Ring edge is null");
            }
            if (edge.getEdgeRingMax() == this) {
                throw new TopologyException("Ring edge visited twice at " + edge.getCoordinate(), edge.getCoordinate());
            }
            if (edge.nextResultMax() == null) {
                throw new TopologyException("Ring edge missing at", edge.dest());
            }
            edge.setEdgeRingMax(this);
        } while ((edge = edge.nextResultMax()) != startEdge);
    }

    public List<OverlayEdgeRing> buildMinimalRings(GeometryFactory geometryFactory) {
        this.linkMinimalRings();
        ArrayList<OverlayEdgeRing> minEdgeRings = new ArrayList<OverlayEdgeRing>();
        OverlayEdge e = this.startEdge;
        do {
            if (e.getEdgeRing() != null) continue;
            OverlayEdgeRing minEr = new OverlayEdgeRing(e, geometryFactory);
            minEdgeRings.add(minEr);
        } while ((e = e.nextResultMax()) != this.startEdge);
        return minEdgeRings;
    }

    private void linkMinimalRings() {
        OverlayEdge e = this.startEdge;
        do {
            MaximalEdgeRing.linkMinRingEdgesAtNode(e, this);
        } while ((e = e.nextResultMax()) != this.startEdge);
    }

    private static void linkMinRingEdgesAtNode(OverlayEdge nodeEdge, MaximalEdgeRing maxRing) {
        OverlayEdge endOut;
        OverlayEdge currMaxRingOut = endOut = nodeEdge;
        OverlayEdge currOut = endOut.oNextOE();
        do {
            if (MaximalEdgeRing.isAlreadyLinked(currOut.symOE(), maxRing)) {
                return;
            }
            currMaxRingOut = currMaxRingOut == null ? MaximalEdgeRing.selectMaxOutEdge(currOut, maxRing) : MaximalEdgeRing.linkMaxInEdge(currOut, currMaxRingOut, maxRing);
        } while ((currOut = currOut.oNextOE()) != endOut);
        if (currMaxRingOut != null) {
            throw new TopologyException("Unmatched edge found during min-ring linking", nodeEdge.getCoordinate());
        }
    }

    private static boolean isAlreadyLinked(OverlayEdge edge, MaximalEdgeRing maxRing) {
        boolean isLinked = edge.getEdgeRingMax() == maxRing && edge.isResultLinked();
        return isLinked;
    }

    private static OverlayEdge selectMaxOutEdge(OverlayEdge currOut, MaximalEdgeRing maxEdgeRing) {
        if (currOut.getEdgeRingMax() == maxEdgeRing) {
            return currOut;
        }
        return null;
    }

    private static OverlayEdge linkMaxInEdge(OverlayEdge currOut, OverlayEdge currMaxRingOut, MaximalEdgeRing maxEdgeRing) {
        OverlayEdge currIn = currOut.symOE();
        if (currIn.getEdgeRingMax() != maxEdgeRing) {
            return currMaxRingOut;
        }
        currIn.setNextResult(currMaxRingOut);
        return null;
    }

    public String toString() {
        Coordinate[] pts = this.getCoordinates();
        return WKTWriter.toLineString(pts);
    }

    private Coordinate[] getCoordinates() {
        CoordinateList coords = new CoordinateList();
        OverlayEdge edge = this.startEdge;
        do {
            coords.add(edge.orig());
        } while (edge.nextResultMax() != null && (edge = edge.nextResultMax()) != this.startEdge);
        coords.add(edge.dest());
        return coords.toCoordinateArray();
    }
}

