/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.dbclient.impl.http;

import com.databricks.internal.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import com.databricks.internal.apache.hc.core5.concurrent.FutureCallback;
import com.databricks.internal.apache.hc.core5.http.nio.AsyncRequestProducer;
import com.databricks.internal.apache.hc.core5.http.nio.AsyncResponseConsumer;
import com.databricks.internal.apache.http.HttpHost;
import com.databricks.internal.apache.http.client.config.RequestConfig;
import com.databricks.internal.apache.http.client.methods.CloseableHttpResponse;
import com.databricks.internal.apache.http.client.methods.HttpUriRequest;
import com.databricks.internal.apache.http.conn.UnsupportedSchemeException;
import com.databricks.internal.apache.http.conn.routing.HttpRoute;
import com.databricks.internal.apache.http.impl.client.CloseableHttpClient;
import com.databricks.internal.apache.http.impl.client.HttpClientBuilder;
import com.databricks.internal.apache.http.impl.client.IdleConnectionEvictor;
import com.databricks.internal.apache.http.impl.conn.DefaultSchemePortResolver;
import com.databricks.internal.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import com.databricks.internal.google.common.annotations.VisibleForTesting;
import com.databricks.internal.io.netty.util.NetUtil;
import com.databricks.internal.sdk.core.ProxyConfig;
import com.databricks.internal.sdk.core.utils.ProxyUtils;
import com.databricks.jdbc.api.internal.IDatabricksConnectionContext;
import com.databricks.jdbc.common.HttpClientType;
import com.databricks.jdbc.common.util.DriverUtil;
import com.databricks.jdbc.common.util.UserAgentManager;
import com.databricks.jdbc.common.util.WildcardUtil;
import com.databricks.jdbc.dbclient.IDatabricksHttpClient;
import com.databricks.jdbc.dbclient.impl.common.ClientConfigurator;
import com.databricks.jdbc.dbclient.impl.common.ConfiguratorUtils;
import com.databricks.jdbc.dbclient.impl.http.DatabricksHttpRetryHandler;
import com.databricks.jdbc.dbclient.impl.http.GlobalAsyncHttpClient;
import com.databricks.jdbc.dbclient.impl.http.RequestSanitizer;
import com.databricks.jdbc.dbclient.impl.http.UCVolumeHttpRetryHandler;
import com.databricks.jdbc.exception.DatabricksDriverException;
import com.databricks.jdbc.exception.DatabricksHttpException;
import com.databricks.jdbc.exception.DatabricksRetryHandlerException;
import com.databricks.jdbc.exception.DatabricksSSLException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import com.databricks.jdbc.model.telemetry.enums.DatabricksDriverErrorCode;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class DatabricksHttpClient
implements IDatabricksHttpClient,
Closeable {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(DatabricksHttpClient.class);
    private static final int DEFAULT_MAX_HTTP_CONNECTIONS = 1000;
    private final PoolingHttpClientConnectionManager connectionManager;
    private final CloseableHttpClient httpClient;
    private IdleConnectionEvictor idleConnectionEvictor;
    private CloseableHttpAsyncClient asyncClient;

    DatabricksHttpClient(IDatabricksConnectionContext connectionContext, HttpClientType type) {
        this.connectionManager = this.initializeConnectionManager(connectionContext);
        this.httpClient = this.makeClosableHttpClient(connectionContext, type);
        this.idleConnectionEvictor = new IdleConnectionEvictor(this.connectionManager, connectionContext.getIdleHttpConnectionExpiry(), TimeUnit.SECONDS);
        this.idleConnectionEvictor.start();
        this.asyncClient = GlobalAsyncHttpClient.getClient();
    }

    @VisibleForTesting
    DatabricksHttpClient(CloseableHttpClient testCloseableHttpClient, PoolingHttpClientConnectionManager testConnectionManager) {
        this.httpClient = testCloseableHttpClient;
        this.connectionManager = testConnectionManager;
    }

    @Override
    public CloseableHttpResponse execute(HttpUriRequest request) throws DatabricksHttpException {
        return this.execute(request, false);
    }

    @Override
    public CloseableHttpResponse execute(HttpUriRequest request, boolean supportGzipEncoding) throws DatabricksHttpException {
        LOGGER.debug("Executing HTTP request {}", RequestSanitizer.sanitizeRequest(request));
        if (!DriverUtil.isRunningAgainstFake() && supportGzipEncoding) {
            request.setHeader("Content-Encoding", "gzip");
        }
        try {
            String userAgentString = UserAgentManager.getUserAgentString();
            if (!WildcardUtil.isNullOrEmpty(userAgentString) && !request.containsHeader("User-Agent")) {
                request.setHeader("User-Agent", userAgentString);
            }
            return this.httpClient.execute(request);
        }
        catch (IOException e) {
            DatabricksHttpClient.throwHttpException(e, request);
            return null;
        }
    }

    @Override
    public <T> Future<T> executeAsync(AsyncRequestProducer requestProducer, AsyncResponseConsumer<T> responseConsumer, FutureCallback<T> callback) {
        return this.asyncClient.execute(requestProducer, responseConsumer, callback);
    }

    @Override
    public void close() throws IOException {
        if (this.idleConnectionEvictor != null) {
            this.idleConnectionEvictor.shutdown();
        }
        if (this.httpClient != null) {
            this.httpClient.close();
        }
        if (this.connectionManager != null) {
            this.connectionManager.shutdown();
        }
        if (this.asyncClient != null) {
            GlobalAsyncHttpClient.releaseClient();
            this.asyncClient = null;
        }
    }

    private PoolingHttpClientConnectionManager initializeConnectionManager(IDatabricksConnectionContext connectionContext) {
        try {
            PoolingHttpClientConnectionManager connectionManager = ConfiguratorUtils.getBaseConnectionManager(connectionContext);
            connectionManager.setMaxTotal(1000);
            connectionManager.setDefaultMaxPerRoute(connectionContext.getHttpMaxConnectionsPerRoute());
            return connectionManager;
        }
        catch (DatabricksSSLException e) {
            LOGGER.error("Failed to initialize HTTP connection manager", e);
            throw new DatabricksDriverException("Failed to initialize HTTP connection manager", DatabricksDriverErrorCode.SSL_HANDSHAKE_ERROR);
        }
    }

    private RequestConfig makeRequestConfig(IDatabricksConnectionContext connectionContext) {
        int timeoutMillis = connectionContext.getSocketTimeout() * 1000;
        int requestTimeout = connectionContext.getHttpConnectionRequestTimeout() != null ? connectionContext.getHttpConnectionRequestTimeout() * 1000 : timeoutMillis;
        return RequestConfig.custom().setConnectionRequestTimeout(requestTimeout).setConnectTimeout(timeoutMillis).setSocketTimeout(timeoutMillis).build();
    }

    private CloseableHttpClient makeClosableHttpClient(IDatabricksConnectionContext connectionContext, HttpClientType type) {
        DatabricksHttpRetryHandler retryHandler = type.equals((Object)HttpClientType.COMMON) ? new DatabricksHttpRetryHandler(connectionContext) : new UCVolumeHttpRetryHandler(connectionContext);
        HttpClientBuilder builder = HttpClientBuilder.create().setConnectionManager(this.connectionManager).setUserAgent(UserAgentManager.getUserAgentString()).setDefaultRequestConfig(this.makeRequestConfig(connectionContext)).setRetryHandler(retryHandler).addInterceptorFirst(retryHandler);
        this.setupProxy(connectionContext, builder);
        if (DriverUtil.isRunningAgainstFake()) {
            this.setFakeServiceRouteInHttpClient(builder);
        }
        return builder.build();
    }

    private static void throwHttpException(Exception e, HttpUriRequest request) throws DatabricksHttpException {
        for (Throwable cause = e; cause != null; cause = cause.getCause()) {
            if (!(cause instanceof DatabricksRetryHandlerException)) continue;
            throw new DatabricksHttpException(cause.getMessage(), cause, DatabricksDriverErrorCode.INVALID_STATE);
        }
        String errorMsg = String.format("Caught error while executing http request: [%s]. Error Message: [%s]", RequestSanitizer.sanitizeRequest(request), e);
        LOGGER.error(e, errorMsg);
        throw new DatabricksHttpException(errorMsg, "08000");
    }

    @VisibleForTesting
    void setupProxy(IDatabricksConnectionContext connectionContext, HttpClientBuilder builder) {
        String proxyHost = null;
        Integer proxyPort = null;
        String proxyUser = null;
        String proxyPassword = null;
        ProxyConfig.ProxyAuthType proxyAuth = connectionContext.getProxyAuthType();
        if (connectionContext.getUseCloudFetchProxy().booleanValue()) {
            proxyHost = connectionContext.getCloudFetchProxyHost();
            proxyPort = connectionContext.getCloudFetchProxyPort();
            proxyUser = connectionContext.getCloudFetchProxyUser();
            proxyPassword = connectionContext.getCloudFetchProxyPassword();
            proxyAuth = connectionContext.getCloudFetchProxyAuthType();
        } else if (connectionContext.getUseProxy().booleanValue()) {
            proxyHost = connectionContext.getProxyHost();
            proxyPort = connectionContext.getProxyPort();
            proxyUser = connectionContext.getProxyUser();
            proxyPassword = connectionContext.getProxyPassword();
            proxyAuth = connectionContext.getProxyAuthType();
        }
        if (proxyHost != null || connectionContext.getUseSystemProxy().booleanValue()) {
            String nonProxyHosts = ClientConfigurator.convertNonProxyHostConfigToBeSystemPropertyCompliant(connectionContext.getNonProxyHosts());
            ProxyConfig proxyConfig = new ProxyConfig().setUseSystemProperties(connectionContext.getUseSystemProxy()).setHost(proxyHost).setPort(proxyPort).setUsername(proxyUser).setPassword(proxyPassword).setProxyAuthType(proxyAuth).setNonProxyHosts(nonProxyHosts);
            ProxyUtils.setupProxy(proxyConfig, builder);
        }
    }

    @VisibleForTesting
    void setFakeServiceRouteInHttpClient(HttpClientBuilder builder) {
        builder.setRoutePlanner((host, request, context) -> {
            HttpHost target;
            try {
                target = new HttpHost(host.getHostName(), DefaultSchemePortResolver.INSTANCE.resolve(host), host.getSchemeName());
            }
            catch (UnsupportedSchemeException e) {
                throw new DatabricksDriverException(e.getMessage(), DatabricksDriverErrorCode.INTEGRATION_TEST_ERROR);
            }
            if (host.getHostName().equalsIgnoreCase(NetUtil.LOCALHOST.getHostName()) || host.getHostName().equalsIgnoreCase("127.0.0.1")) {
                return new HttpRoute(target, null, false);
            }
            HttpHost proxy = HttpHost.create(System.getProperty(host.toURI() + ".fakeServiceURI"));
            return new HttpRoute(target, null, proxy, false);
        });
    }
}

