/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl;

import com.databricks.jdbc.exception.DatabricksSQLException;
import com.databricks.jdbc.model.client.thrift.generated.TColumn;
import com.databricks.jdbc.model.client.thrift.generated.TRowSet;
import com.databricks.jdbc.model.telemetry.enums.DatabricksDriverErrorCode;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.List;

public class ColumnarRowView {
    private final List<TColumn> columns;
    private final int rowCount;
    private final ColumnAccessor[] columnAccessors;

    public ColumnarRowView(TRowSet rowSet) throws DatabricksSQLException {
        List<TColumn> list = this.columns = rowSet != null ? rowSet.getColumns() : null;
        if (this.columns == null || this.columns.isEmpty()) {
            this.rowCount = 0;
            this.columnAccessors = new ColumnAccessor[0];
        } else {
            this.rowCount = this.getRowCountFromFirstColumn();
            this.columnAccessors = new ColumnAccessor[this.columns.size()];
            for (int i = 0; i < this.columns.size(); ++i) {
                this.columnAccessors[i] = ColumnarRowView.createColumnAccessor(this.columns.get(i));
            }
        }
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getColumnCount() {
        return this.columns != null ? this.columns.size() : 0;
    }

    public Object getValue(int rowIndex, int columnIndex) throws DatabricksSQLException {
        if (rowIndex < 0 || rowIndex >= this.rowCount) {
            throw new DatabricksSQLException("Row index out of bounds: " + rowIndex, DatabricksDriverErrorCode.INVALID_STATE);
        }
        if (columnIndex < 0 || columnIndex >= this.columnAccessors.length) {
            throw new DatabricksSQLException("Column index out of bounds: " + columnIndex, DatabricksDriverErrorCode.INVALID_STATE);
        }
        return this.columnAccessors[columnIndex].getValue(rowIndex);
    }

    public Object[] materializeRow(int rowIndex) throws DatabricksSQLException {
        if (rowIndex < 0 || rowIndex >= this.rowCount) {
            throw new DatabricksSQLException("Row index out of bounds: " + rowIndex, DatabricksDriverErrorCode.INVALID_STATE);
        }
        Object[] row = new Object[this.columnAccessors.length];
        for (int col = 0; col < this.columnAccessors.length; ++col) {
            row[col] = this.columnAccessors[col].getValue(rowIndex);
        }
        return row;
    }

    private int getRowCountFromFirstColumn() throws DatabricksSQLException {
        if (this.columns.isEmpty()) {
            return 0;
        }
        TColumn firstColumn = this.columns.get(0);
        return ColumnarRowView.getColumnSize(firstColumn);
    }

    private static int getColumnSize(TColumn column) throws DatabricksSQLException {
        if (column.isSetBinaryVal()) {
            return column.getBinaryVal().getValuesSize();
        }
        if (column.isSetBoolVal()) {
            return column.getBoolVal().getValuesSize();
        }
        if (column.isSetByteVal()) {
            return column.getByteVal().getValuesSize();
        }
        if (column.isSetDoubleVal()) {
            return column.getDoubleVal().getValuesSize();
        }
        if (column.isSetI16Val()) {
            return column.getI16Val().getValuesSize();
        }
        if (column.isSetI32Val()) {
            return column.getI32Val().getValuesSize();
        }
        if (column.isSetI64Val()) {
            return column.getI64Val().getValuesSize();
        }
        if (column.isSetStringVal()) {
            return column.getStringVal().getValuesSize();
        }
        throw new DatabricksSQLException("Unsupported column type: " + String.valueOf(column), DatabricksDriverErrorCode.UNSUPPORTED_OPERATION);
    }

    private static ColumnAccessor createColumnAccessor(TColumn column) throws DatabricksSQLException {
        if (column.isSetBinaryVal()) {
            return new TypedColumnAccessor<ByteBuffer>(column.getBinaryVal().getValues(), column.getBinaryVal().getNulls());
        }
        if (column.isSetBoolVal()) {
            return new TypedColumnAccessor<Boolean>(column.getBoolVal().getValues(), column.getBoolVal().getNulls());
        }
        if (column.isSetByteVal()) {
            return new TypedColumnAccessor<Byte>(column.getByteVal().getValues(), column.getByteVal().getNulls());
        }
        if (column.isSetDoubleVal()) {
            return new TypedColumnAccessor<Double>(column.getDoubleVal().getValues(), column.getDoubleVal().getNulls());
        }
        if (column.isSetI16Val()) {
            return new TypedColumnAccessor<Short>(column.getI16Val().getValues(), column.getI16Val().getNulls());
        }
        if (column.isSetI32Val()) {
            return new TypedColumnAccessor<Integer>(column.getI32Val().getValues(), column.getI32Val().getNulls());
        }
        if (column.isSetI64Val()) {
            return new TypedColumnAccessor<Long>(column.getI64Val().getValues(), column.getI64Val().getNulls());
        }
        if (column.isSetStringVal()) {
            return new TypedColumnAccessor<String>(column.getStringVal().getValues(), column.getStringVal().getNulls());
        }
        throw new DatabricksSQLException("Unsupported column type: " + String.valueOf(column), DatabricksDriverErrorCode.UNSUPPORTED_OPERATION);
    }

    private static class TypedColumnAccessor<T>
    implements ColumnAccessor {
        private final List<T> values;
        private final BitSet nullBits;

        public TypedColumnAccessor(List<T> values, byte[] nulls) {
            this.values = values;
            this.nullBits = nulls != null ? BitSet.valueOf(nulls) : null;
        }

        @Override
        public Object getValue(int rowIndex) {
            if (this.nullBits != null && this.nullBits.get(rowIndex)) {
                return null;
            }
            return this.values.get(rowIndex);
        }
    }

    private static interface ColumnAccessor {
        public Object getValue(int var1);
    }
}

