/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.core.oauth;

import com.databricks.internal.google.common.base.Strings;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.oauth.IDToken;
import com.databricks.internal.sdk.core.oauth.IDTokenSource;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;

public class FileIDTokenSource
implements IDTokenSource {
    private final String filePath;

    public FileIDTokenSource(String filePath) {
        this.filePath = filePath;
    }

    @Override
    public IDToken getIDToken(String audience) {
        List<String> rawLines;
        boolean isFileExists;
        Path path;
        if (Strings.isNullOrEmpty(this.filePath)) {
            throw new IllegalArgumentException("File path cannot be null or empty");
        }
        try {
            path = Paths.get(this.filePath, new String[0]);
        }
        catch (InvalidPathException e) {
            throw new DatabricksException("Invalid file path: " + this.filePath, e);
        }
        try {
            isFileExists = Files.exists(path, new LinkOption[0]);
        }
        catch (SecurityException e) {
            throw new DatabricksException(String.format("Security permission denied when checking if file %s exists: %s", this.filePath, e.getMessage()), e);
        }
        if (!isFileExists) {
            throw new DatabricksException(String.format("File %s does not exist", this.filePath));
        }
        try {
            rawLines = Files.readAllLines(path, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new DatabricksException(String.format("Failed to read ID token from file %s: %s", this.filePath, e.getMessage()), e);
        }
        catch (SecurityException e) {
            throw new DatabricksException(String.format("Security permission denied when reading file %s: %s", this.filePath, e.getMessage()), e);
        }
        List nonEmptyLines = rawLines.stream().map(String::trim).filter(line -> !line.isEmpty()).collect(Collectors.toList());
        if (nonEmptyLines.isEmpty()) {
            throw new DatabricksException(String.format("File %s contains only empty lines", this.filePath));
        }
        if (nonEmptyLines.size() > 1) {
            throw new DatabricksException(String.format("The token should be a single line but the file %s contains %d non-empty lines", this.filePath, nonEmptyLines.size()));
        }
        String token = (String)nonEmptyLines.get(0);
        try {
            return new IDToken(token);
        }
        catch (IllegalArgumentException e) {
            throw new DatabricksException(String.format("Received empty ID token from file %s", this.filePath));
        }
    }
}

