/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.telemetry;

import com.databricks.internal.apache.http.client.methods.CloseableHttpResponse;
import com.databricks.internal.apache.http.client.methods.HttpPost;
import com.databricks.internal.apache.http.client.utils.URIBuilder;
import com.databricks.internal.apache.http.entity.StringEntity;
import com.databricks.internal.apache.http.util.EntityUtils;
import com.databricks.internal.fasterxml.jackson.annotation.JsonInclude;
import com.databricks.internal.fasterxml.jackson.databind.ObjectMapper;
import com.databricks.internal.sdk.core.DatabricksConfig;
import com.databricks.jdbc.api.internal.IDatabricksConnectionContext;
import com.databricks.jdbc.common.DatabricksJdbcConstants;
import com.databricks.jdbc.common.util.HttpUtil;
import com.databricks.jdbc.dbclient.IDatabricksHttpClient;
import com.databricks.jdbc.dbclient.impl.http.DatabricksHttpClientFactory;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import com.databricks.jdbc.model.telemetry.TelemetryRequest;
import com.databricks.jdbc.model.telemetry.TelemetryResponse;
import com.databricks.jdbc.telemetry.ITelemetryPushClient;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;

public class TelemetryPushClient
implements ITelemetryPushClient {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(TelemetryPushClient.class);
    private static final String REQUEST_ID_HEADER = "x-request-id";
    private final boolean isAuthenticated;
    private final IDatabricksConnectionContext connectionContext;
    private final DatabricksConfig databricksConfig;
    private final ObjectMapper objectMapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);

    public TelemetryPushClient(boolean isAuthenticated, IDatabricksConnectionContext connectionContext, DatabricksConfig databricksConfig) {
        this.isAuthenticated = isAuthenticated;
        this.connectionContext = connectionContext;
        this.databricksConfig = databricksConfig;
    }

    @Override
    public void pushEvent(TelemetryRequest request) throws Exception {
        block12: {
            IDatabricksHttpClient httpClient = DatabricksHttpClientFactory.getInstance().getClient(this.connectionContext);
            String path = this.isAuthenticated ? "/telemetry-ext" : "/telemetry-unauth";
            String uri = new URIBuilder(this.connectionContext.getHostUrl()).setPath(path).toString();
            HttpPost post = new HttpPost(uri);
            post.setEntity(new StringEntity(this.objectMapper.writeValueAsString(request), StandardCharsets.UTF_8));
            DatabricksJdbcConstants.JSON_HTTP_HEADERS.forEach(post::addHeader);
            Map<String, String> authHeaders = this.isAuthenticated ? this.databricksConfig.authenticate() : Collections.emptyMap();
            authHeaders.forEach(post::addHeader);
            try (CloseableHttpResponse response = httpClient.execute(post);){
                if (!HttpUtil.isSuccessfulHttpResponse(response)) {
                    LOGGER.trace("Failed to push telemetry logs with error response: {}", response.getStatusLine());
                    return;
                }
                TelemetryResponse telResponse = this.objectMapper.readValue(EntityUtils.toString(response.getEntity()), TelemetryResponse.class);
                LOGGER.trace("Pushed Telemetry logs with request-Id {} with events {} with error count {}", response.getFirstHeader(REQUEST_ID_HEADER), telResponse.getNumProtoSuccess(), telResponse.getErrors().size());
                if (!telResponse.getErrors().isEmpty()) {
                    LOGGER.trace("Failed to push telemetry logs with error: {}", telResponse.getErrors());
                }
                if ((long)request.getProtoLogs().size() != telResponse.getNumProtoSuccess()) {
                    LOGGER.debug("Partial failure while pushing telemetry logs with error response: {}, request count: {}, upload count: {}", telResponse.getErrors(), request.getProtoLogs().size(), telResponse.getNumProtoSuccess());
                }
            }
            catch (Exception e) {
                LOGGER.debug("Failed to push telemetry logs with error: {}, request: {}", e.getMessage(), this.objectMapper.writeValueAsString(request));
                if (!this.connectionContext.isTelemetryCircuitBreakerEnabled()) break block12;
                throw e;
            }
        }
    }
}

