/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.exception;

import com.databricks.jdbc.common.TelemetryLogLevel;
import com.databricks.jdbc.common.util.DatabricksThreadContextHolder;
import com.databricks.jdbc.model.telemetry.enums.DatabricksDriverErrorCode;
import com.databricks.jdbc.telemetry.TelemetryHelper;
import java.sql.BatchUpdateException;
import java.util.Arrays;

public class DatabricksBatchUpdateException
extends BatchUpdateException {
    private long[] longUpdateCounts;
    private int[] updateCounts;

    public DatabricksBatchUpdateException(String reason, DatabricksDriverErrorCode internalErrorCode, long[] longUpdateCounts) {
        super(reason, internalErrorCode.toString(), (int[])null);
        this.longUpdateCounts = longUpdateCounts == null ? null : Arrays.copyOf(longUpdateCounts, longUpdateCounts.length);
        this.updateCounts = longUpdateCounts == null ? null : this.copyUpdateCount(longUpdateCounts);
        TelemetryHelper.exportFailureLog(DatabricksThreadContextHolder.getConnectionContext(), internalErrorCode.toString(), reason, TelemetryLogLevel.ERROR);
    }

    public DatabricksBatchUpdateException(String reason, String SQLState, int vendorCode, long[] longUpdateCounts, Throwable cause) {
        super(reason, SQLState, vendorCode, longUpdateCounts, cause);
        this.longUpdateCounts = longUpdateCounts == null ? null : Arrays.copyOf(longUpdateCounts, longUpdateCounts.length);
        this.updateCounts = longUpdateCounts == null ? null : this.copyUpdateCount(longUpdateCounts);
        TelemetryHelper.exportFailureLog(DatabricksThreadContextHolder.getConnectionContext(), SQLState, reason, TelemetryLogLevel.ERROR);
    }

    @Override
    public long[] getLargeUpdateCounts() {
        return this.longUpdateCounts == null ? null : Arrays.copyOf(this.longUpdateCounts, this.longUpdateCounts.length);
    }

    @Override
    public int[] getUpdateCounts() {
        return this.updateCounts == null ? null : Arrays.copyOf(this.updateCounts, this.updateCounts.length);
    }

    private int[] copyUpdateCount(long[] uc) {
        int[] copy = new int[uc.length];
        for (int i = 0; i < uc.length; ++i) {
            copy[i] = (int)uc[i];
        }
        return copy;
    }
}

