/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.dbclient.impl.common;

import com.databricks.jdbc.api.impl.ImmutableSessionInfo;
import com.databricks.jdbc.common.AllPurposeCluster;
import com.databricks.jdbc.common.DatabricksClientType;
import com.databricks.jdbc.common.IDatabricksComputeResource;
import com.databricks.jdbc.common.Warehouse;
import com.databricks.jdbc.common.util.DatabricksThriftUtil;
import com.databricks.jdbc.dbclient.impl.thrift.ResourceId;
import com.databricks.jdbc.exception.DatabricksParsingException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import com.databricks.jdbc.model.client.thrift.generated.THandleIdentifier;
import com.databricks.jdbc.model.client.thrift.generated.TSessionHandle;
import com.databricks.jdbc.model.telemetry.enums.DatabricksDriverErrorCode;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.Objects;

public class SessionId {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(SessionId.class);
    final DatabricksClientType clientType;
    final String guid;
    final String secret;
    final IDatabricksComputeResource clusterResource;

    SessionId(DatabricksClientType clientType, String guid, String secret, IDatabricksComputeResource clusterResource) {
        this.clientType = clientType;
        this.guid = guid;
        this.secret = secret;
        this.clusterResource = clusterResource;
    }

    public SessionId(String sessionId, IDatabricksComputeResource warehouseId) {
        this(DatabricksClientType.SEA, sessionId, null, warehouseId);
    }

    public SessionId(THandleIdentifier identifier, IDatabricksComputeResource computeResource) {
        this(DatabricksClientType.THRIFT, ResourceId.fromBytes(identifier.getGuid()).toString(), ResourceId.fromBytes(identifier.getSecret()).toString(), computeResource);
    }

    public static SessionId create(ImmutableSessionInfo sessionInfo) {
        if (sessionInfo.computeResource() instanceof Warehouse) {
            return new SessionId(sessionInfo.sessionId(), sessionInfo.computeResource());
        }
        assert (sessionInfo.sessionHandle() != null);
        return new SessionId(sessionInfo.sessionHandle().getSessionId(), sessionInfo.computeResource());
    }

    public static SessionId deserialize(String serializedSessionId) throws SQLException {
        String[] parts = serializedSessionId.split("\\|");
        if (parts.length != 3) {
            String errorMessage = String.format("Session ID has invalid number of parts %s", serializedSessionId);
            LOGGER.error(errorMessage);
            throw new DatabricksParsingException(errorMessage, DatabricksDriverErrorCode.SESSION_ID_PARSING_EXCEPTION);
        }
        switch (parts[0]) {
            case "s": {
                return new SessionId(parts[2], (IDatabricksComputeResource)new Warehouse(parts[1]));
            }
            case "t": {
                return new SessionId(DatabricksClientType.THRIFT, parts[1], parts[2], null);
            }
        }
        String errorMessage = String.format("Session ID has 3 parts but is invalid %s", serializedSessionId);
        LOGGER.error(errorMessage);
        throw new DatabricksParsingException(errorMessage, DatabricksDriverErrorCode.SESSION_ID_PARSING_EXCEPTION);
    }

    public String toString() {
        switch (this.clientType) {
            case SEA: {
                return String.format("s|%s|%s", ((Warehouse)this.clusterResource).getWarehouseId(), this.guid);
            }
            case THRIFT: {
                return String.format("t|%s|%s", this.guid, this.secret);
            }
        }
        return this.guid;
    }

    public ImmutableSessionInfo getSessionInfo() {
        switch (this.clientType) {
            case THRIFT: {
                return ImmutableSessionInfo.builder().sessionId(DatabricksThriftUtil.byteBufferToString(ByteBuffer.wrap(ResourceId.fromBase64(this.guid).toBytes()))).computeResource(this.clusterResource != null ? this.clusterResource : new AllPurposeCluster("", "")).sessionHandle(new TSessionHandle(new THandleIdentifier().setGuid(ResourceId.fromBase64(this.guid).toBytes()).setSecret(ResourceId.fromBase64(this.secret).toBytes()))).build();
            }
            case SEA: {
                return ImmutableSessionInfo.builder().sessionHandle(null).sessionId(this.guid).computeResource(this.clusterResource).build();
            }
        }
        return null;
    }

    public DatabricksClientType getClientType() {
        return this.clientType;
    }

    public boolean equals(Object otherSession) {
        if (!(otherSession instanceof SessionId) || this.clientType != ((SessionId)otherSession).clientType) {
            return false;
        }
        return Objects.equals(this.guid, ((SessionId)otherSession).guid) && Objects.equals(this.secret, ((SessionId)otherSession).secret) && (this.clientType == DatabricksClientType.THRIFT || Objects.equals(this.clusterResource, ((SessionId)otherSession).clusterResource));
    }
}

