/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl.converters;

import com.databricks.jdbc.api.impl.converters.ObjectConverter;
import com.databricks.jdbc.exception.DatabricksSQLException;
import com.databricks.jdbc.exception.DatabricksValidationException;
import com.databricks.jdbc.model.telemetry.enums.DatabricksDriverErrorCode;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;

public class DateConverter
implements ObjectConverter {
    @Override
    public Date toDate(Object object) throws DatabricksSQLException {
        if (object instanceof String) {
            return Date.valueOf((String)object);
        }
        if (object instanceof Date) {
            return (Date)object;
        }
        throw new DatabricksSQLException("Unsupported type for DateObjectConverter: " + String.valueOf(object.getClass()), DatabricksDriverErrorCode.UNSUPPORTED_OPERATION);
    }

    @Override
    public long toLong(Object object) throws DatabricksSQLException {
        LocalDate localStartDate = LocalDate.ofEpochDay(0L);
        return ChronoUnit.DAYS.between(localStartDate, this.toDate(object).toLocalDate());
    }

    @Override
    public short toShort(Object object) throws DatabricksSQLException {
        long epochDays = this.toLong(object);
        if ((long)((short)epochDays) == epochDays) {
            return (short)epochDays;
        }
        throw new DatabricksValidationException("Invalid conversion: Date value out of short range");
    }

    @Override
    public int toInt(Object object) throws DatabricksSQLException {
        return (int)this.toLong(object);
    }

    @Override
    public BigInteger toBigInteger(Object object) throws DatabricksSQLException {
        return BigInteger.valueOf(this.toLong(object));
    }

    @Override
    public LocalDate toLocalDate(Object object) throws DatabricksSQLException {
        return this.toDate(object).toLocalDate();
    }

    @Override
    public String toString(Object object) throws DatabricksSQLException {
        return this.toDate(object).toString();
    }

    @Override
    public Timestamp toTimestamp(Object object) throws DatabricksSQLException {
        return Timestamp.valueOf(this.toDate(object).toLocalDate().atStartOfDay());
    }
}

