/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl;

import com.databricks.jdbc.api.IDatabricksGeospatial;
import com.databricks.jdbc.api.impl.converters.WKTConverter;
import com.databricks.jdbc.exception.DatabricksValidationException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import java.util.Objects;

public abstract class AbstractDatabricksGeospatial
implements IDatabricksGeospatial {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(AbstractDatabricksGeospatial.class);
    private final String wkt;
    private final int srid;
    private final byte[] wkb;

    protected AbstractDatabricksGeospatial(String wkt, int srid) throws DatabricksValidationException {
        if (wkt == null || wkt.trim().isEmpty()) {
            LOGGER.error("WKT string cannot be null or empty");
            throw new DatabricksValidationException("WKT string cannot be null or empty");
        }
        this.wkt = wkt.trim();
        this.srid = srid;
        this.wkb = WKTConverter.toWKB(this.wkt);
    }

    @Override
    public byte[] getWKB() {
        return this.wkb;
    }

    @Override
    public int getSRID() {
        return this.srid;
    }

    @Override
    public String getWKT() {
        return this.wkt;
    }

    public String toString() {
        return String.format("SRID=%d;%s", this.srid, this.wkt);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractDatabricksGeospatial that = (AbstractDatabricksGeospatial)obj;
        return this.srid == that.srid && this.wkt.equals(that.wkt);
    }

    public int hashCode() {
        return Objects.hash(this.wkt, this.srid);
    }

    @Override
    public abstract String getType();
}

