/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.qualitymonitorv2;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.http.Request;
import com.databricks.internal.sdk.service.qualitymonitorv2.CreateQualityMonitorRequest;
import com.databricks.internal.sdk.service.qualitymonitorv2.DeleteQualityMonitorRequest;
import com.databricks.internal.sdk.service.qualitymonitorv2.GetQualityMonitorRequest;
import com.databricks.internal.sdk.service.qualitymonitorv2.ListQualityMonitorRequest;
import com.databricks.internal.sdk.service.qualitymonitorv2.ListQualityMonitorResponse;
import com.databricks.internal.sdk.service.qualitymonitorv2.QualityMonitor;
import com.databricks.internal.sdk.service.qualitymonitorv2.QualityMonitorV2Service;
import com.databricks.internal.sdk.service.qualitymonitorv2.UpdateQualityMonitorRequest;
import com.databricks.internal.sdk.support.Generated;
import java.io.IOException;

@Generated
class QualityMonitorV2Impl
implements QualityMonitorV2Service {
    private final ApiClient apiClient;

    public QualityMonitorV2Impl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public QualityMonitor createQualityMonitor(CreateQualityMonitorRequest request) {
        String path = "/api/2.0/quality-monitors";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request.getQualityMonitor()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, QualityMonitor.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteQualityMonitor(DeleteQualityMonitorRequest request) {
        String path = String.format("/api/2.0/quality-monitors/%s/%s", request.getObjectType(), request.getObjectId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public QualityMonitor getQualityMonitor(GetQualityMonitorRequest request) {
        String path = String.format("/api/2.0/quality-monitors/%s/%s", request.getObjectType(), request.getObjectId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, QualityMonitor.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListQualityMonitorResponse listQualityMonitor(ListQualityMonitorRequest request) {
        String path = "/api/2.0/quality-monitors";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListQualityMonitorResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public QualityMonitor updateQualityMonitor(UpdateQualityMonitorRequest request) {
        String path = String.format("/api/2.0/quality-monitors/%s/%s", request.getObjectType(), request.getObjectId());
        try {
            Request req = new Request("PUT", path, this.apiClient.serialize(request.getQualityMonitor()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, QualityMonitor.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

