/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.marketplace;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.marketplace.BatchGetListingsRequest;
import com.databricks.internal.sdk.service.marketplace.BatchGetListingsResponse;
import com.databricks.internal.sdk.service.marketplace.ConsumerListingsImpl;
import com.databricks.internal.sdk.service.marketplace.ConsumerListingsService;
import com.databricks.internal.sdk.service.marketplace.GetListingRequest;
import com.databricks.internal.sdk.service.marketplace.GetListingResponse;
import com.databricks.internal.sdk.service.marketplace.ListListingsRequest;
import com.databricks.internal.sdk.service.marketplace.ListListingsResponse;
import com.databricks.internal.sdk.service.marketplace.Listing;
import com.databricks.internal.sdk.service.marketplace.SearchListingsRequest;
import com.databricks.internal.sdk.service.marketplace.SearchListingsResponse;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class ConsumerListingsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(ConsumerListingsAPI.class);
    private final ConsumerListingsService impl;

    public ConsumerListingsAPI(ApiClient apiClient) {
        this.impl = new ConsumerListingsImpl(apiClient);
    }

    public ConsumerListingsAPI(ConsumerListingsService mock) {
        this.impl = mock;
    }

    public BatchGetListingsResponse batchGet(BatchGetListingsRequest request) {
        return this.impl.batchGet(request);
    }

    public GetListingResponse get(String id) {
        return this.get(new GetListingRequest().setId(id));
    }

    public GetListingResponse get(GetListingRequest request) {
        return this.impl.get(request);
    }

    public Iterable<Listing> list(ListListingsRequest request) {
        return new Paginator(request, this.impl::list, ListListingsResponse::getListings, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public Iterable<Listing> search(String query) {
        return this.search(new SearchListingsRequest().setQuery(query));
    }

    public Iterable<Listing> search(SearchListingsRequest request) {
        return new Paginator(request, this.impl::search, SearchListingsResponse::getListings, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public ConsumerListingsService impl() {
        return this.impl;
    }
}

