/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.cleanrooms;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.http.Request;
import com.databricks.internal.sdk.service.cleanrooms.CleanRoomAutoApprovalRule;
import com.databricks.internal.sdk.service.cleanrooms.CleanRoomAutoApprovalRulesService;
import com.databricks.internal.sdk.service.cleanrooms.CreateCleanRoomAutoApprovalRuleRequest;
import com.databricks.internal.sdk.service.cleanrooms.DeleteCleanRoomAutoApprovalRuleRequest;
import com.databricks.internal.sdk.service.cleanrooms.GetCleanRoomAutoApprovalRuleRequest;
import com.databricks.internal.sdk.service.cleanrooms.ListCleanRoomAutoApprovalRulesRequest;
import com.databricks.internal.sdk.service.cleanrooms.ListCleanRoomAutoApprovalRulesResponse;
import com.databricks.internal.sdk.service.cleanrooms.UpdateCleanRoomAutoApprovalRuleRequest;
import com.databricks.internal.sdk.support.Generated;
import java.io.IOException;

@Generated
class CleanRoomAutoApprovalRulesImpl
implements CleanRoomAutoApprovalRulesService {
    private final ApiClient apiClient;

    public CleanRoomAutoApprovalRulesImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public CleanRoomAutoApprovalRule create(CreateCleanRoomAutoApprovalRuleRequest request) {
        String path = String.format("/api/2.0/clean-rooms/%s/auto-approval-rules", request.getCleanRoomName());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, CleanRoomAutoApprovalRule.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteCleanRoomAutoApprovalRuleRequest request) {
        String path = String.format("/api/2.0/clean-rooms/%s/auto-approval-rules/%s", request.getCleanRoomName(), request.getRuleId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public CleanRoomAutoApprovalRule get(GetCleanRoomAutoApprovalRuleRequest request) {
        String path = String.format("/api/2.0/clean-rooms/%s/auto-approval-rules/%s", request.getCleanRoomName(), request.getRuleId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, CleanRoomAutoApprovalRule.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListCleanRoomAutoApprovalRulesResponse list(ListCleanRoomAutoApprovalRulesRequest request) {
        String path = String.format("/api/2.0/clean-rooms/%s/auto-approval-rules", request.getCleanRoomName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListCleanRoomAutoApprovalRulesResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public CleanRoomAutoApprovalRule update(UpdateCleanRoomAutoApprovalRuleRequest request) {
        String path = String.format("/api/2.0/clean-rooms/%s/auto-approval-rules/%s", request.getCleanRoomName(), request.getRuleId());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request.getAutoApprovalRule()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, CleanRoomAutoApprovalRule.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

