/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.catalog;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.catalog.DisableRequest;
import com.databricks.internal.sdk.service.catalog.EnableRequest;
import com.databricks.internal.sdk.service.catalog.ListSystemSchemasRequest;
import com.databricks.internal.sdk.service.catalog.ListSystemSchemasResponse;
import com.databricks.internal.sdk.service.catalog.SystemSchemaInfo;
import com.databricks.internal.sdk.service.catalog.SystemSchemasImpl;
import com.databricks.internal.sdk.service.catalog.SystemSchemasService;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class SystemSchemasAPI {
    private static final Logger LOG = LoggerFactory.getLogger(SystemSchemasAPI.class);
    private final SystemSchemasService impl;

    public SystemSchemasAPI(ApiClient apiClient) {
        this.impl = new SystemSchemasImpl(apiClient);
    }

    public SystemSchemasAPI(SystemSchemasService mock) {
        this.impl = mock;
    }

    public void disable(String metastoreId, String schemaName) {
        this.disable(new DisableRequest().setMetastoreId(metastoreId).setSchemaName(schemaName));
    }

    public void disable(DisableRequest request) {
        this.impl.disable(request);
    }

    public void enable(EnableRequest request) {
        this.impl.enable(request);
    }

    public Iterable<SystemSchemaInfo> list(String metastoreId) {
        return this.list(new ListSystemSchemasRequest().setMetastoreId(metastoreId));
    }

    public Iterable<SystemSchemaInfo> list(ListSystemSchemasRequest request) {
        return new Paginator(request, this.impl::list, ListSystemSchemasResponse::getSchemas, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public SystemSchemasService impl() {
        return this.impl;
    }
}

