/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.catalog;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.catalog.CreateStorageCredential;
import com.databricks.internal.sdk.service.catalog.DeleteStorageCredentialRequest;
import com.databricks.internal.sdk.service.catalog.GetStorageCredentialRequest;
import com.databricks.internal.sdk.service.catalog.ListStorageCredentialsRequest;
import com.databricks.internal.sdk.service.catalog.ListStorageCredentialsResponse;
import com.databricks.internal.sdk.service.catalog.StorageCredentialInfo;
import com.databricks.internal.sdk.service.catalog.StorageCredentialsImpl;
import com.databricks.internal.sdk.service.catalog.StorageCredentialsService;
import com.databricks.internal.sdk.service.catalog.UpdateStorageCredential;
import com.databricks.internal.sdk.service.catalog.ValidateStorageCredential;
import com.databricks.internal.sdk.service.catalog.ValidateStorageCredentialResponse;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class StorageCredentialsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(StorageCredentialsAPI.class);
    private final StorageCredentialsService impl;

    public StorageCredentialsAPI(ApiClient apiClient) {
        this.impl = new StorageCredentialsImpl(apiClient);
    }

    public StorageCredentialsAPI(StorageCredentialsService mock) {
        this.impl = mock;
    }

    public StorageCredentialInfo create(CreateStorageCredential request) {
        return this.impl.create(request);
    }

    public void delete(String name) {
        this.delete(new DeleteStorageCredentialRequest().setName(name));
    }

    public void delete(DeleteStorageCredentialRequest request) {
        this.impl.delete(request);
    }

    public StorageCredentialInfo get(String name) {
        return this.get(new GetStorageCredentialRequest().setName(name));
    }

    public StorageCredentialInfo get(GetStorageCredentialRequest request) {
        return this.impl.get(request);
    }

    public Iterable<StorageCredentialInfo> list(ListStorageCredentialsRequest request) {
        return new Paginator(request, this.impl::list, ListStorageCredentialsResponse::getStorageCredentials, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public StorageCredentialInfo update(UpdateStorageCredential request) {
        return this.impl.update(request);
    }

    public ValidateStorageCredentialResponse validate(ValidateStorageCredential request) {
        return this.impl.validate(request);
    }

    public StorageCredentialsService impl() {
        return this.impl;
    }
}

