/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.catalog;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.catalog.AccountStorageCredentialsImpl;
import com.databricks.internal.sdk.service.catalog.AccountStorageCredentialsService;
import com.databricks.internal.sdk.service.catalog.AccountsCreateStorageCredential;
import com.databricks.internal.sdk.service.catalog.AccountsCreateStorageCredentialInfo;
import com.databricks.internal.sdk.service.catalog.AccountsDeleteStorageCredentialResponse;
import com.databricks.internal.sdk.service.catalog.AccountsStorageCredentialInfo;
import com.databricks.internal.sdk.service.catalog.AccountsUpdateStorageCredential;
import com.databricks.internal.sdk.service.catalog.AccountsUpdateStorageCredentialResponse;
import com.databricks.internal.sdk.service.catalog.DeleteAccountStorageCredentialRequest;
import com.databricks.internal.sdk.service.catalog.GetAccountStorageCredentialRequest;
import com.databricks.internal.sdk.service.catalog.ListAccountStorageCredentialsRequest;
import com.databricks.internal.sdk.service.catalog.ListAccountStorageCredentialsResponse;
import com.databricks.internal.sdk.service.catalog.StorageCredentialInfo;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class AccountStorageCredentialsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(AccountStorageCredentialsAPI.class);
    private final AccountStorageCredentialsService impl;

    public AccountStorageCredentialsAPI(ApiClient apiClient) {
        this.impl = new AccountStorageCredentialsImpl(apiClient);
    }

    public AccountStorageCredentialsAPI(AccountStorageCredentialsService mock) {
        this.impl = mock;
    }

    public AccountsCreateStorageCredentialInfo create(AccountsCreateStorageCredential request) {
        return this.impl.create(request);
    }

    public AccountsDeleteStorageCredentialResponse delete(String metastoreId, String storageCredentialName) {
        return this.delete(new DeleteAccountStorageCredentialRequest().setMetastoreId(metastoreId).setStorageCredentialName(storageCredentialName));
    }

    public AccountsDeleteStorageCredentialResponse delete(DeleteAccountStorageCredentialRequest request) {
        return this.impl.delete(request);
    }

    public AccountsStorageCredentialInfo get(String metastoreId, String storageCredentialName) {
        return this.get(new GetAccountStorageCredentialRequest().setMetastoreId(metastoreId).setStorageCredentialName(storageCredentialName));
    }

    public AccountsStorageCredentialInfo get(GetAccountStorageCredentialRequest request) {
        return this.impl.get(request);
    }

    public Iterable<StorageCredentialInfo> list(String metastoreId) {
        return this.list(new ListAccountStorageCredentialsRequest().setMetastoreId(metastoreId));
    }

    public Iterable<StorageCredentialInfo> list(ListAccountStorageCredentialsRequest request) {
        return new Paginator(request, this.impl::list, ListAccountStorageCredentialsResponse::getStorageCredentials, response -> null);
    }

    public AccountsUpdateStorageCredentialResponse update(AccountsUpdateStorageCredential request) {
        return this.impl.update(request);
    }

    public AccountStorageCredentialsService impl() {
        return this.impl;
    }
}

