/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.core.oauth;

import com.databricks.internal.google.auto.value.AutoValue;
import com.databricks.internal.sdk.core.http.HttpClient;
import com.databricks.internal.sdk.core.oauth.AutoValue_DataPlaneTokenSource_TokenSourceKey;
import com.databricks.internal.sdk.core.oauth.CachedTokenSource;
import com.databricks.internal.sdk.core.oauth.EndpointTokenSource;
import com.databricks.internal.sdk.core.oauth.Token;
import com.databricks.internal.sdk.core.oauth.TokenSource;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class DataPlaneTokenSource {
    private final HttpClient httpClient;
    private final TokenSource cpTokenSource;
    private final String host;
    private final boolean asyncDisabled;
    private final ConcurrentHashMap<TokenSourceKey, CachedTokenSource> sourcesCache;

    public DataPlaneTokenSource(HttpClient httpClient, TokenSource cpTokenSource, String host, boolean asyncDisabled) {
        this.httpClient = Objects.requireNonNull(httpClient, "HTTP client cannot be null");
        this.cpTokenSource = Objects.requireNonNull(cpTokenSource, "Control plane token source cannot be null");
        this.host = Objects.requireNonNull(host, "Host cannot be null");
        this.asyncDisabled = asyncDisabled;
        if (host.isEmpty()) {
            throw new IllegalArgumentException("Host cannot be empty");
        }
        this.sourcesCache = new ConcurrentHashMap();
    }

    public Token getToken(String endpoint, String authDetails) {
        Objects.requireNonNull(endpoint, "Data plane endpoint URL cannot be null");
        Objects.requireNonNull(authDetails, "Authorization details cannot be null");
        if (endpoint.isEmpty()) {
            throw new IllegalArgumentException("Data plane endpoint URL cannot be empty");
        }
        if (authDetails.isEmpty()) {
            throw new IllegalArgumentException("Authorization details cannot be empty");
        }
        TokenSourceKey key = TokenSourceKey.create(endpoint, authDetails);
        CachedTokenSource specificSource = this.sourcesCache.computeIfAbsent(key, k -> new CachedTokenSource.Builder(new EndpointTokenSource(this.cpTokenSource, k.authDetails(), this.httpClient, this.host)).setAsyncDisabled(this.asyncDisabled).build());
        return specificSource.getToken();
    }

    @AutoValue
    static abstract class TokenSourceKey {
        TokenSourceKey() {
        }

        abstract String endpoint();

        abstract String authDetails();

        static TokenSourceKey create(String endpoint, String authDetails) {
            return new AutoValue_DataPlaneTokenSource_TokenSourceKey(endpoint, authDetails);
        }
    }
}

