/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.simplify;

import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.geom.CoordinateList;

class LinkedRing {
    private static final int NO_COORD_INDEX = -1;
    private final Coordinate[] coord;
    private int[] next = null;
    private int[] prev = null;
    private int size;

    public LinkedRing(Coordinate[] pts) {
        this.coord = pts;
        this.size = pts.length - 1;
        this.next = LinkedRing.createNextLinks(this.size);
        this.prev = LinkedRing.createPrevLinks(this.size);
    }

    private static int[] createNextLinks(int size) {
        int[] next = new int[size];
        for (int i = 0; i < size; ++i) {
            next[i] = i + 1;
        }
        next[size - 1] = 0;
        return next;
    }

    private static int[] createPrevLinks(int size) {
        int[] prev = new int[size];
        for (int i = 0; i < size; ++i) {
            prev[i] = i - 1;
        }
        prev[0] = size - 1;
        return prev;
    }

    public int size() {
        return this.size;
    }

    public int next(int i) {
        return this.next[i];
    }

    public int prev(int i) {
        return this.prev[i];
    }

    public Coordinate getCoordinate(int index) {
        return this.coord[index];
    }

    public Coordinate prevCoordinate(int index) {
        return this.coord[this.prev(index)];
    }

    public Coordinate nextCoordinate(int index) {
        return this.coord[this.next(index)];
    }

    public boolean hasCoordinate(int index) {
        return index >= 0 && index < this.prev.length && this.prev[index] != -1;
    }

    public void remove(int index) {
        int inext;
        int iprev = this.prev[index];
        this.next[iprev] = inext = this.next[index];
        this.prev[inext] = iprev;
        this.prev[index] = -1;
        this.next[index] = -1;
        --this.size;
    }

    public Coordinate[] getCoordinates() {
        CoordinateList coords = new CoordinateList();
        for (int i = 0; i < this.coord.length - 1; ++i) {
            if (this.prev[i] == -1) continue;
            coords.add(this.coord[i].copy(), false);
        }
        coords.closeRing();
        return coords.toCoordinateArray();
    }
}

