/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.operation.relateng;

import com.databricks.internal.jts.algorithm.PolygonNodeTopology;
import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.geom.Location;
import com.databricks.internal.jts.io.WKTWriter;
import com.databricks.internal.jts.operation.relateng.RelateNode;
import com.databricks.internal.jts.util.Assert;
import java.util.List;

class RelateEdge {
    public static final boolean IS_FORWARD = true;
    public static final boolean IS_REVERSE = false;
    public static final int DIM_UNKNOWN = -1;
    private static int LOC_UNKNOWN = -1;
    private RelateNode node;
    private Coordinate dirPt;
    private int aDim = -1;
    private int aLocLeft = LOC_UNKNOWN;
    private int aLocRight = LOC_UNKNOWN;
    private int aLocLine = LOC_UNKNOWN;
    private int bDim = -1;
    private int bLocLeft = LOC_UNKNOWN;
    private int bLocRight = LOC_UNKNOWN;
    private int bLocLine = LOC_UNKNOWN;

    public static RelateEdge create(RelateNode node, Coordinate dirPt, boolean isA, int dim, boolean isForward) {
        if (dim == 2) {
            return new RelateEdge(node, dirPt, isA, isForward);
        }
        return new RelateEdge(node, dirPt, isA);
    }

    public static int findKnownEdgeIndex(List<RelateEdge> edges, boolean isA) {
        for (int i = 0; i < edges.size(); ++i) {
            RelateEdge e = edges.get(i);
            if (!e.isKnown(isA)) continue;
            return i;
        }
        return -1;
    }

    public static void setAreaInterior(List<RelateEdge> edges, boolean isA) {
        for (RelateEdge e : edges) {
            e.setAreaInterior(isA);
        }
    }

    public RelateEdge(RelateNode node, Coordinate pt, boolean isA, boolean isForward) {
        this.node = node;
        this.dirPt = pt;
        this.setLocationsArea(isA, isForward);
    }

    public RelateEdge(RelateNode node, Coordinate pt, boolean isA) {
        this.node = node;
        this.dirPt = pt;
        this.setLocationsLine(isA);
    }

    public RelateEdge(RelateNode node, Coordinate pt, boolean isA, int locLeft, int locRight, int locLine) {
        this.node = node;
        this.dirPt = pt;
        this.setLocations(isA, locLeft, locRight, locLine);
    }

    private void setLocations(boolean isA, int locLeft, int locRight, int locLine) {
        if (isA) {
            this.aDim = 2;
            this.aLocLeft = locLeft;
            this.aLocRight = locRight;
            this.aLocLine = locLine;
        } else {
            this.bDim = 2;
            this.bLocLeft = locLeft;
            this.bLocRight = locRight;
            this.bLocLine = locLine;
        }
    }

    private void setLocationsLine(boolean isA) {
        if (isA) {
            this.aDim = 1;
            this.aLocLeft = 2;
            this.aLocRight = 2;
            this.aLocLine = 0;
        } else {
            this.bDim = 1;
            this.bLocLeft = 2;
            this.bLocRight = 2;
            this.bLocLine = 0;
        }
    }

    private void setLocationsArea(boolean isA, boolean isForward) {
        int locRight;
        int locLeft = isForward ? 2 : 0;
        int n = locRight = isForward ? 0 : 2;
        if (isA) {
            this.aDim = 2;
            this.aLocLeft = locLeft;
            this.aLocRight = locRight;
            this.aLocLine = 1;
        } else {
            this.bDim = 2;
            this.bLocLeft = locLeft;
            this.bLocRight = locRight;
            this.bLocLine = 1;
        }
    }

    public int compareToEdge(Coordinate edgeDirPt) {
        return PolygonNodeTopology.compareAngle(this.node.getCoordinate(), this.dirPt, edgeDirPt);
    }

    public void merge(boolean isA, Coordinate dirPt, int dim, boolean isForward) {
        int locEdge = 0;
        int locLeft = 2;
        int locRight = 2;
        if (dim == 2) {
            locEdge = 1;
            locLeft = isForward ? 2 : 0;
            int n = locRight = isForward ? 0 : 2;
        }
        if (!this.isKnown(isA)) {
            this.setDimension(isA, dim);
            this.setOn(isA, locEdge);
            this.setLeft(isA, locLeft);
            this.setRight(isA, locRight);
            return;
        }
        this.mergeDimEdgeLoc(isA, locEdge);
        this.mergeSideLocation(isA, 1, locLeft);
        this.mergeSideLocation(isA, 2, locRight);
    }

    private void mergeDimEdgeLoc(boolean isA, int locEdge) {
        int dim;
        int n = dim = locEdge == 1 ? 2 : 1;
        if (dim == 2 && this.dimension(isA) == 1) {
            this.setDimension(isA, dim);
            this.setOn(isA, 1);
        }
    }

    private void mergeSideLocation(boolean isA, int pos, int loc) {
        int currLoc = this.location(isA, pos);
        if (currLoc != 0) {
            this.setLocation(isA, pos, loc);
        }
    }

    private void setDimension(boolean isA, int dimension) {
        if (isA) {
            this.aDim = dimension;
        } else {
            this.bDim = dimension;
        }
    }

    public void setLocation(boolean isA, int pos, int loc) {
        switch (pos) {
            case 1: {
                this.setLeft(isA, loc);
                break;
            }
            case 2: {
                this.setRight(isA, loc);
                break;
            }
            case 0: {
                this.setOn(isA, loc);
            }
        }
    }

    public void setAllLocations(boolean isA, int loc) {
        this.setLeft(isA, loc);
        this.setRight(isA, loc);
        this.setOn(isA, loc);
    }

    public void setUnknownLocations(boolean isA, int loc) {
        if (!this.isKnown(isA, 1)) {
            this.setLocation(isA, 1, loc);
        }
        if (!this.isKnown(isA, 2)) {
            this.setLocation(isA, 2, loc);
        }
        if (!this.isKnown(isA, 0)) {
            this.setLocation(isA, 0, loc);
        }
    }

    private void setLeft(boolean isA, int loc) {
        if (isA) {
            this.aLocLeft = loc;
        } else {
            this.bLocLeft = loc;
        }
    }

    private void setRight(boolean isA, int loc) {
        if (isA) {
            this.aLocRight = loc;
        } else {
            this.bLocRight = loc;
        }
    }

    private void setOn(boolean isA, int loc) {
        if (isA) {
            this.aLocLine = loc;
        } else {
            this.bLocLine = loc;
        }
    }

    public int location(boolean isA, int position) {
        if (isA) {
            switch (position) {
                case 1: {
                    return this.aLocLeft;
                }
                case 2: {
                    return this.aLocRight;
                }
                case 0: {
                    return this.aLocLine;
                }
            }
        } else {
            switch (position) {
                case 1: {
                    return this.bLocLeft;
                }
                case 2: {
                    return this.bLocRight;
                }
                case 0: {
                    return this.bLocLine;
                }
            }
        }
        Assert.shouldNeverReachHere();
        return LOC_UNKNOWN;
    }

    private int dimension(boolean isA) {
        return isA ? this.aDim : this.bDim;
    }

    private boolean isKnown(boolean isA) {
        if (isA) {
            return this.aDim != -1;
        }
        return this.bDim != -1;
    }

    private boolean isKnown(boolean isA, int pos) {
        return this.location(isA, pos) != LOC_UNKNOWN;
    }

    public boolean isInterior(boolean isA, int position) {
        return this.location(isA, position) == 0;
    }

    public void setDimLocations(boolean isA, int dim, int loc) {
        if (isA) {
            this.aDim = dim;
            this.aLocLeft = loc;
            this.aLocRight = loc;
            this.aLocLine = loc;
        } else {
            this.bDim = dim;
            this.bLocLeft = loc;
            this.bLocRight = loc;
            this.bLocLine = loc;
        }
    }

    public void setAreaInterior(boolean isA) {
        if (isA) {
            this.aLocLeft = 0;
            this.aLocRight = 0;
            this.aLocLine = 0;
        } else {
            this.bLocLeft = 0;
            this.bLocRight = 0;
            this.bLocLine = 0;
        }
    }

    public String toString() {
        return WKTWriter.toLineString(this.node.getCoordinate(), this.dirPt) + " - " + this.labelString();
    }

    private String labelString() {
        StringBuilder buf = new StringBuilder();
        buf.append("A:");
        buf.append(this.locationString(true));
        buf.append("/B:");
        buf.append(this.locationString(false));
        return buf.toString();
    }

    private String locationString(boolean isA) {
        StringBuilder buf = new StringBuilder();
        buf.append(Location.toLocationSymbol(this.location(isA, 1)));
        buf.append(Location.toLocationSymbol(this.location(isA, 0)));
        buf.append(Location.toLocationSymbol(this.location(isA, 2)));
        return buf.toString();
    }
}

