/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.noding.snapround;

import com.databricks.internal.jts.geom.Geometry;
import com.databricks.internal.jts.geom.GeometryFactory;
import com.databricks.internal.jts.geom.LineString;
import com.databricks.internal.jts.geom.PrecisionModel;
import com.databricks.internal.jts.geom.util.LinearComponentExtracter;
import com.databricks.internal.jts.noding.NodedSegmentString;
import com.databricks.internal.jts.noding.NodingValidator;
import com.databricks.internal.jts.noding.SegmentString;
import com.databricks.internal.jts.noding.snapround.SnapRoundingNoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GeometryNoder {
    private GeometryFactory geomFact;
    private PrecisionModel pm;
    private boolean isValidityChecked = false;

    public GeometryNoder(PrecisionModel pm) {
        this.pm = pm;
    }

    public void setValidate(boolean isValidityChecked) {
        this.isValidityChecked = isValidityChecked;
    }

    public List node(Collection geoms) {
        Geometry geom0 = (Geometry)geoms.iterator().next();
        this.geomFact = geom0.getFactory();
        List segStrings = this.toSegmentStrings(this.extractLines(geoms));
        SnapRoundingNoder sr = new SnapRoundingNoder(this.pm);
        sr.computeNodes(segStrings);
        Collection nodedLines = sr.getNodedSubstrings();
        if (this.isValidityChecked) {
            NodingValidator nv = new NodingValidator(nodedLines);
            nv.checkValid();
        }
        return this.toLineStrings(nodedLines);
    }

    private List toLineStrings(Collection segStrings) {
        ArrayList<LineString> lines = new ArrayList<LineString>();
        for (SegmentString ss : segStrings) {
            if (ss.size() < 2) continue;
            lines.add(this.geomFact.createLineString(ss.getCoordinates()));
        }
        return lines;
    }

    private List extractLines(Collection geoms) {
        ArrayList lines = new ArrayList();
        LinearComponentExtracter lce = new LinearComponentExtracter(lines);
        for (Geometry geom : geoms) {
            geom.apply(lce);
        }
        return lines;
    }

    private List toSegmentStrings(Collection lines) {
        ArrayList<NodedSegmentString> segStrings = new ArrayList<NodedSegmentString>();
        for (LineString line : lines) {
            segStrings.add(new NodedSegmentString(line.getCoordinates(), null));
        }
        return segStrings;
    }
}

