/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.linearref;

import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.geom.Geometry;
import com.databricks.internal.jts.geom.LineSegment;
import com.databricks.internal.jts.linearref.LinearIterator;
import com.databricks.internal.jts.util.Assert;

class LengthIndexOfPoint {
    private Geometry linearGeom;

    public static double indexOf(Geometry linearGeom, Coordinate inputPt) {
        LengthIndexOfPoint locater = new LengthIndexOfPoint(linearGeom);
        return locater.indexOf(inputPt);
    }

    public static double indexOfAfter(Geometry linearGeom, Coordinate inputPt, double minIndex) {
        LengthIndexOfPoint locater = new LengthIndexOfPoint(linearGeom);
        return locater.indexOfAfter(inputPt, minIndex);
    }

    public LengthIndexOfPoint(Geometry linearGeom) {
        this.linearGeom = linearGeom;
    }

    public double indexOf(Coordinate inputPt) {
        return this.indexOfFromStart(inputPt, -1.0);
    }

    public double indexOfAfter(Coordinate inputPt, double minIndex) {
        if (minIndex < 0.0) {
            return this.indexOf(inputPt);
        }
        double endIndex = this.linearGeom.getLength();
        if (endIndex < minIndex) {
            return endIndex;
        }
        double closestAfter = this.indexOfFromStart(inputPt, minIndex);
        Assert.isTrue(closestAfter >= minIndex, "computed index is before specified minimum index");
        return closestAfter;
    }

    private double indexOfFromStart(Coordinate inputPt, double minIndex) {
        double minDistance = Double.MAX_VALUE;
        double ptMeasure = minIndex;
        double segmentStartMeasure = 0.0;
        LineSegment seg = new LineSegment();
        LinearIterator it = new LinearIterator(this.linearGeom);
        while (it.hasNext()) {
            if (!it.isEndOfLine()) {
                seg.p0 = it.getSegmentStart();
                seg.p1 = it.getSegmentEnd();
                double segDistance = seg.distance(inputPt);
                double segMeasureToPt = this.segmentNearestMeasure(seg, inputPt, segmentStartMeasure);
                if (segDistance < minDistance && segMeasureToPt > minIndex) {
                    ptMeasure = segMeasureToPt;
                    minDistance = segDistance;
                }
                segmentStartMeasure += seg.getLength();
            }
            it.next();
        }
        return ptMeasure;
    }

    private double segmentNearestMeasure(LineSegment seg, Coordinate inputPt, double segmentStartMeasure) {
        double projFactor = seg.projectionFactor(inputPt);
        if (projFactor <= 0.0) {
            return segmentStartMeasure;
        }
        if (projFactor <= 1.0) {
            return segmentStartMeasure + projFactor * seg.getLength();
        }
        return segmentStartMeasure + seg.getLength();
    }
}

