/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.index.intervalrtree;

import com.databricks.internal.jts.index.ItemVisitor;
import com.databricks.internal.jts.index.intervalrtree.IntervalRTreeBranchNode;
import com.databricks.internal.jts.index.intervalrtree.IntervalRTreeLeafNode;
import com.databricks.internal.jts.index.intervalrtree.IntervalRTreeNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SortedPackedIntervalRTree {
    private final List leaves = new ArrayList();
    private volatile IntervalRTreeNode root = null;

    public void insert(double min2, double max, Object item) {
        if (this.root != null) {
            throw new IllegalStateException("Index cannot be added to once it has been queried");
        }
        this.leaves.add(new IntervalRTreeLeafNode(min2, max, item));
    }

    private synchronized void init() {
        if (this.root != null) {
            return;
        }
        if (this.leaves.size() == 0) {
            return;
        }
        this.buildRoot();
    }

    private void buildRoot() {
        if (this.root != null) {
            return;
        }
        this.root = this.buildTree();
    }

    private IntervalRTreeNode buildTree() {
        Collections.sort(this.leaves, new IntervalRTreeNode.NodeComparator());
        ArrayList src = this.leaves;
        ArrayList temp = null;
        ArrayList dest = new ArrayList();
        while (true) {
            this.buildLevel(src, dest);
            if (dest.size() == 1) {
                return (IntervalRTreeNode)dest.get(0);
            }
            temp = src;
            src = dest;
            dest = temp;
        }
    }

    private void buildLevel(List src, List dest) {
        dest.clear();
        for (int i = 0; i < src.size(); i += 2) {
            IntervalRTreeNode n2;
            IntervalRTreeNode n1 = (IntervalRTreeNode)src.get(i);
            IntervalRTreeNode intervalRTreeNode = n2 = i + 1 < src.size() ? (IntervalRTreeNode)src.get(i) : null;
            if (n2 == null) {
                dest.add(n1);
                continue;
            }
            IntervalRTreeBranchNode node = new IntervalRTreeBranchNode((IntervalRTreeNode)src.get(i), (IntervalRTreeNode)src.get(i + 1));
            dest.add(node);
        }
    }

    public void query(double min2, double max, ItemVisitor visitor) {
        this.init();
        if (this.root == null) {
            return;
        }
        this.root.query(min2, max, visitor);
    }
}

