/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.index.chain;

import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.geom.Quadrant;
import com.databricks.internal.jts.index.chain.MonotoneChain;
import java.util.ArrayList;
import java.util.List;

public class MonotoneChainBuilder {
    public static List getChains(Coordinate[] pts) {
        return MonotoneChainBuilder.getChains(pts, null);
    }

    public static List getChains(Coordinate[] pts, Object context) {
        int chainEnd;
        ArrayList<MonotoneChain> mcList = new ArrayList<MonotoneChain>();
        if (pts.length == 0) {
            return mcList;
        }
        int chainStart = 0;
        do {
            chainEnd = MonotoneChainBuilder.findChainEnd(pts, chainStart);
            MonotoneChain mc = new MonotoneChain(pts, chainStart, chainEnd, context);
            mcList.add(mc);
        } while ((chainStart = chainEnd) < pts.length - 1);
        return mcList;
    }

    private static int findChainEnd(Coordinate[] pts, int start) {
        int quad;
        int last;
        int safeStart;
        for (safeStart = start; safeStart < pts.length - 1 && pts[safeStart].equals2D(pts[safeStart + 1]); ++safeStart) {
        }
        if (safeStart >= pts.length - 1) {
            return pts.length - 1;
        }
        int chainQuad = Quadrant.quadrant(pts[safeStart], pts[safeStart + 1]);
        for (last = start + 1; last < pts.length && (pts[last - 1].equals2D(pts[last]) || (quad = Quadrant.quadrant(pts[last - 1], pts[last])) == chainQuad); ++last) {
        }
        return last - 1;
    }
}

