/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.geomgraph;

import com.databricks.internal.jts.algorithm.Orientation;
import com.databricks.internal.jts.algorithm.PointLocation;
import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.geom.Envelope;
import com.databricks.internal.jts.geom.GeometryFactory;
import com.databricks.internal.jts.geom.LinearRing;
import com.databricks.internal.jts.geom.Polygon;
import com.databricks.internal.jts.geom.TopologyException;
import com.databricks.internal.jts.geomgraph.DirectedEdge;
import com.databricks.internal.jts.geomgraph.DirectedEdgeStar;
import com.databricks.internal.jts.geomgraph.Edge;
import com.databricks.internal.jts.geomgraph.Label;
import com.databricks.internal.jts.geomgraph.Node;
import com.databricks.internal.jts.util.Assert;
import java.util.ArrayList;
import java.util.List;

public abstract class EdgeRing {
    protected DirectedEdge startDe;
    private int maxNodeDegree = -1;
    private List edges = new ArrayList();
    private List pts = new ArrayList();
    private Label label = new Label(-1);
    private LinearRing ring;
    private boolean isHole;
    private EdgeRing shell;
    private ArrayList holes = new ArrayList();
    protected GeometryFactory geometryFactory;

    public EdgeRing(DirectedEdge start, GeometryFactory geometryFactory) {
        this.geometryFactory = geometryFactory;
        this.computePoints(start);
        this.computeRing();
    }

    public boolean isIsolated() {
        return this.label.getGeometryCount() == 1;
    }

    public boolean isHole() {
        return this.isHole;
    }

    public Coordinate getCoordinate(int i) {
        return (Coordinate)this.pts.get(i);
    }

    public LinearRing getLinearRing() {
        return this.ring;
    }

    public Label getLabel() {
        return this.label;
    }

    public boolean isShell() {
        return this.shell == null;
    }

    public EdgeRing getShell() {
        return this.shell;
    }

    public void setShell(EdgeRing shell) {
        this.shell = shell;
        if (shell != null) {
            shell.addHole(this);
        }
    }

    public void addHole(EdgeRing ring) {
        this.holes.add(ring);
    }

    public Polygon toPolygon(GeometryFactory geometryFactory) {
        LinearRing[] holeLR = new LinearRing[this.holes.size()];
        for (int i = 0; i < this.holes.size(); ++i) {
            holeLR[i] = ((EdgeRing)this.holes.get(i)).getLinearRing();
        }
        Polygon poly = geometryFactory.createPolygon(this.getLinearRing(), holeLR);
        return poly;
    }

    public void computeRing() {
        if (this.ring != null) {
            return;
        }
        Coordinate[] coord = new Coordinate[this.pts.size()];
        for (int i = 0; i < this.pts.size(); ++i) {
            coord[i] = (Coordinate)this.pts.get(i);
        }
        this.ring = this.geometryFactory.createLinearRing(coord);
        this.isHole = Orientation.isCCW(this.ring.getCoordinates());
    }

    public abstract DirectedEdge getNext(DirectedEdge var1);

    public abstract void setEdgeRing(DirectedEdge var1, EdgeRing var2);

    public List getEdges() {
        return this.edges;
    }

    protected void computePoints(DirectedEdge start) {
        this.startDe = start;
        DirectedEdge de = start;
        boolean isFirstEdge = true;
        do {
            if (de == null) {
                throw new TopologyException("Found null DirectedEdge");
            }
            if (de.getEdgeRing() == this) {
                throw new TopologyException("Directed Edge visited twice during ring-building at " + de.getCoordinate());
            }
            this.edges.add(de);
            Label label = de.getLabel();
            Assert.isTrue(label.isArea());
            this.mergeLabel(label);
            this.addPoints(de.getEdge(), de.isForward(), isFirstEdge);
            isFirstEdge = false;
            this.setEdgeRing(de, this);
        } while ((de = this.getNext(de)) != this.startDe);
    }

    public int getMaxNodeDegree() {
        if (this.maxNodeDegree < 0) {
            this.computeMaxNodeDegree();
        }
        return this.maxNodeDegree;
    }

    private void computeMaxNodeDegree() {
        this.maxNodeDegree = 0;
        DirectedEdge de = this.startDe;
        do {
            Node node;
            int degree;
            if ((degree = ((DirectedEdgeStar)(node = de.getNode()).getEdges()).getOutgoingDegree(this)) <= this.maxNodeDegree) continue;
            this.maxNodeDegree = degree;
        } while ((de = this.getNext(de)) != this.startDe);
        this.maxNodeDegree *= 2;
    }

    public void setInResult() {
        DirectedEdge de = this.startDe;
        do {
            de.getEdge().setInResult(true);
        } while ((de = de.getNext()) != this.startDe);
    }

    protected void mergeLabel(Label deLabel) {
        this.mergeLabel(deLabel, 0);
        this.mergeLabel(deLabel, 1);
    }

    protected void mergeLabel(Label deLabel, int geomIndex) {
        int loc = deLabel.getLocation(geomIndex, 2);
        if (loc == -1) {
            return;
        }
        if (this.label.getLocation(geomIndex) == -1) {
            this.label.setLocation(geomIndex, loc);
            return;
        }
    }

    protected void addPoints(Edge edge, boolean isForward, boolean isFirstEdge) {
        Coordinate[] edgePts = edge.getCoordinates();
        if (isForward) {
            int startIndex = 1;
            if (isFirstEdge) {
                startIndex = 0;
            }
            for (int i = startIndex; i < edgePts.length; ++i) {
                this.pts.add(edgePts[i]);
            }
        } else {
            int startIndex = edgePts.length - 2;
            if (isFirstEdge) {
                startIndex = edgePts.length - 1;
            }
            for (int i = startIndex; i >= 0; --i) {
                this.pts.add(edgePts[i]);
            }
        }
    }

    public boolean containsPoint(Coordinate p) {
        LinearRing shell = this.getLinearRing();
        Envelope env = shell.getEnvelopeInternal();
        if (!env.contains(p)) {
            return false;
        }
        if (!PointLocation.isInRing(p, shell.getCoordinates())) {
            return false;
        }
        for (EdgeRing hole : this.holes) {
            if (!hole.containsPoint(p)) continue;
            return false;
        }
        return true;
    }
}

