/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.geom;

import com.databricks.internal.jts.geom.Geometry;
import com.databricks.internal.jts.geom.GeometryCollection;
import com.databricks.internal.jts.geom.GeometryFactory;
import com.databricks.internal.jts.geom.LineString;
import com.databricks.internal.jts.geom.Lineal;
import com.databricks.internal.jts.geom.PrecisionModel;
import com.databricks.internal.jts.operation.BoundaryOp;

public class MultiLineString
extends GeometryCollection
implements Lineal {
    private static final long serialVersionUID = 8166665132445433741L;

    public MultiLineString(LineString[] lineStrings, PrecisionModel precisionModel, int SRID) {
        super(lineStrings, new GeometryFactory(precisionModel, SRID));
    }

    public MultiLineString(LineString[] lineStrings, GeometryFactory factory) {
        super(lineStrings, factory);
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public boolean hasDimension(int dim) {
        return dim == 1;
    }

    @Override
    public int getBoundaryDimension() {
        if (this.isClosed()) {
            return -1;
        }
        return 0;
    }

    @Override
    public String getGeometryType() {
        return "MultiLineString";
    }

    public boolean isClosed() {
        if (this.isEmpty()) {
            return false;
        }
        for (int i = 0; i < this.geometries.length; ++i) {
            if (((LineString)this.geometries[i]).isClosed()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Geometry getBoundary() {
        return new BoundaryOp(this).getBoundary();
    }

    @Override
    public MultiLineString reverse() {
        return (MultiLineString)super.reverse();
    }

    @Override
    protected MultiLineString reverseInternal() {
        LineString[] lineStrings = new LineString[this.geometries.length];
        for (int i = 0; i < lineStrings.length; ++i) {
            lineStrings[i] = (LineString)this.geometries[i].reverse();
        }
        return new MultiLineString(lineStrings, this.factory);
    }

    @Override
    protected MultiLineString copyInternal() {
        LineString[] lineStrings = new LineString[this.geometries.length];
        for (int i = 0; i < lineStrings.length; ++i) {
            lineStrings[i] = (LineString)this.geometries[i].copy();
        }
        return new MultiLineString(lineStrings, this.factory);
    }

    @Override
    public boolean equalsExact(Geometry other, double tolerance) {
        if (!this.isEquivalentClass(other)) {
            return false;
        }
        return super.equalsExact(other, tolerance);
    }

    @Override
    protected int getTypeCode() {
        return 4;
    }
}

