/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.geom;

import com.databricks.internal.jts.geom.Coordinate;

public class CoordinateXY
extends Coordinate {
    private static final long serialVersionUID = 3532307803472313082L;
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = -1;
    public static final int M = -1;

    public CoordinateXY() {
    }

    public CoordinateXY(double x, double y) {
        super(x, y, Double.NaN);
    }

    public CoordinateXY(Coordinate coord) {
        super(coord.x, coord.y);
    }

    public CoordinateXY(CoordinateXY coord) {
        super(coord.x, coord.y);
    }

    @Override
    public CoordinateXY copy() {
        return new CoordinateXY(this);
    }

    @Override
    public Coordinate create() {
        return new CoordinateXY();
    }

    @Override
    public double getZ() {
        return Double.NaN;
    }

    @Override
    public void setZ(double z) {
        throw new IllegalArgumentException("CoordinateXY dimension 2 does not support z-ordinate");
    }

    @Override
    public void setCoordinate(Coordinate other) {
        this.x = other.x;
        this.y = other.y;
        this.z = other.getZ();
    }

    @Override
    public double getOrdinate(int ordinateIndex) {
        switch (ordinateIndex) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
        }
        return Double.NaN;
    }

    @Override
    public void setOrdinate(int ordinateIndex, double value) {
        switch (ordinateIndex) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid ordinate index: " + ordinateIndex);
            }
        }
    }

    @Override
    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }
}

