/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.bouncycastle.crypto.generators;

import com.databricks.internal.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.databricks.internal.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.databricks.internal.bouncycastle.crypto.CryptoServicePurpose;
import com.databricks.internal.bouncycastle.crypto.CryptoServicesRegistrar;
import com.databricks.internal.bouncycastle.crypto.KeyGenerationParameters;
import com.databricks.internal.bouncycastle.crypto.constraints.ConstraintUtils;
import com.databricks.internal.bouncycastle.crypto.constraints.DefaultServiceProperties;
import com.databricks.internal.bouncycastle.crypto.params.DSAKeyGenerationParameters;
import com.databricks.internal.bouncycastle.crypto.params.DSAParameters;
import com.databricks.internal.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import com.databricks.internal.bouncycastle.crypto.params.DSAPublicKeyParameters;
import com.databricks.internal.bouncycastle.math.ec.WNafUtil;
import com.databricks.internal.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class DSAKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private DSAKeyGenerationParameters param;

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (DSAKeyGenerationParameters)keyGenerationParameters;
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties("DSAKeyGen", ConstraintUtils.bitsOfSecurityFor(this.param.getParameters().getP()), this.param.getParameters(), CryptoServicePurpose.KEYGEN));
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        DSAParameters dSAParameters = this.param.getParameters();
        BigInteger bigInteger = DSAKeyPairGenerator.generatePrivateKey(dSAParameters.getQ(), this.param.getRandom());
        BigInteger bigInteger2 = DSAKeyPairGenerator.calculatePublicKey(dSAParameters.getP(), dSAParameters.getG(), bigInteger);
        return new AsymmetricCipherKeyPair(new DSAPublicKeyParameters(bigInteger2, dSAParameters), new DSAPrivateKeyParameters(bigInteger, dSAParameters));
    }

    private static BigInteger generatePrivateKey(BigInteger bigInteger, SecureRandom secureRandom) {
        BigInteger bigInteger2;
        int n = bigInteger.bitLength() >>> 2;
        while (WNafUtil.getNafWeight(bigInteger2 = BigIntegers.createRandomInRange(ONE, bigInteger.subtract(ONE), secureRandom)) < n) {
        }
        return bigInteger2;
    }

    private static BigInteger calculatePublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        return bigInteger2.modPow(bigInteger3, bigInteger);
    }
}

