/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.bouncycastle.cert.crmf.jcajce;

import com.databricks.internal.bouncycastle.asn1.crmf.EncryptedValue;
import com.databricks.internal.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.databricks.internal.bouncycastle.cert.crmf.CRMFException;
import com.databricks.internal.bouncycastle.cert.crmf.EncryptedValueBuilder;
import com.databricks.internal.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import com.databricks.internal.bouncycastle.operator.KeyWrapper;
import com.databricks.internal.bouncycastle.operator.OutputEncryptor;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

public class JcaEncryptedValueBuilder
extends EncryptedValueBuilder {
    public JcaEncryptedValueBuilder(KeyWrapper keyWrapper, OutputEncryptor outputEncryptor) {
        super(keyWrapper, outputEncryptor);
    }

    public EncryptedValue build(X509Certificate x509Certificate) throws CertificateEncodingException, CRMFException {
        return this.build(new JcaX509CertificateHolder(x509Certificate));
    }

    public EncryptedValue build(PrivateKey privateKey) throws CertificateEncodingException, CRMFException {
        return this.build(PrivateKeyInfo.getInstance(privateKey.getEncoded()));
    }
}

