/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.apache.thrift;

import com.databricks.internal.apache.hc.core5.http.ClassicHttpResponse;
import com.databricks.internal.apache.hc.core5.http.HttpEntity;
import com.databricks.internal.apache.hc.core5.http.HttpException;
import com.databricks.internal.apache.hc.core5.http.io.HttpClientResponseHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class THttpClientResponseHandler
implements HttpClientResponseHandler<InputStream> {
    @Override
    public InputStream handleResponse(ClassicHttpResponse response) throws HttpException, IOException {
        ByteArrayInputStream byteArrayInputStream;
        block11: {
            InputStream is = response.getEntity().getContent();
            try {
                int responseCode = response.getCode();
                if (responseCode != 200) {
                    throw new IOException("HTTP Response code: " + responseCode);
                }
                byte[] readByteArray = THttpClientResponseHandler.readIntoByteArray(is);
                try {
                    THttpClientResponseHandler.consume(response.getEntity());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                byteArrayInputStream = new ByteArrayInputStream(readByteArray);
                if (is == null) break block11;
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            is.close();
        }
        return byteArrayInputStream;
    }

    private static byte[] readIntoByteArray(InputStream is) throws IOException {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        do {
            if ((len = is.read(buf)) <= 0) continue;
            baos.write(buf, 0, len);
        } while (-1 != len);
        return baos.toByteArray();
    }

    private static void consume(HttpEntity entity) throws IOException {
        InputStream instream;
        if (entity == null) {
            return;
        }
        if (entity.isStreaming() && (instream = entity.getContent()) != null) {
            instream.close();
        }
    }
}

