/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.apache.arrow.vector.ipc.message;

import com.databricks.internal.apache.arrow.flatbuf.Message;
import com.databricks.internal.apache.arrow.memory.ArrowBuf;
import com.databricks.internal.apache.arrow.memory.BufferAllocator;
import com.databricks.internal.apache.arrow.vector.ipc.ReadChannel;
import com.databricks.internal.apache.arrow.vector.ipc.message.MessageMetadataResult;
import com.databricks.internal.apache.arrow.vector.ipc.message.MessageResult;
import com.databricks.internal.apache.arrow.vector.ipc.message.MessageSerializer;
import java.io.IOException;

public class MessageChannelReader
implements AutoCloseable {
    protected ReadChannel in;
    protected BufferAllocator allocator;

    public MessageChannelReader(ReadChannel in, BufferAllocator allocator) {
        this.in = in;
        this.allocator = allocator;
    }

    public MessageResult readNext() throws IOException {
        MessageMetadataResult result = MessageSerializer.readMessage(this.in);
        if (result == null) {
            return null;
        }
        Message message = result.getMessage();
        ArrowBuf bodyBuffer = null;
        if (result.messageHasBody()) {
            long bodyLength = result.getMessageBodyLength();
            bodyBuffer = MessageSerializer.readMessageBody(this.in, bodyLength, this.allocator);
        }
        return new MessageResult(message, bodyBuffer);
    }

    public long bytesRead() {
        return this.in.bytesRead();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

