/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.apache.arrow.vector.complex.impl;

import com.databricks.internal.apache.arrow.vector.TimeStampNanoTZVector;
import com.databricks.internal.apache.arrow.vector.complex.impl.AbstractFieldWriter;
import com.databricks.internal.apache.arrow.vector.holders.NullableTimeStampNanoTZHolder;
import com.databricks.internal.apache.arrow.vector.holders.TimeStampNanoTZHolder;
import com.databricks.internal.apache.arrow.vector.types.pojo.Field;

public class TimeStampNanoTZWriterImpl
extends AbstractFieldWriter {
    final TimeStampNanoTZVector vector;

    public TimeStampNanoTZWriterImpl(TimeStampNanoTZVector vector) {
        this.vector = vector;
    }

    @Override
    public Field getField() {
        return this.vector.getField();
    }

    @Override
    public int getValueCapacity() {
        return this.vector.getValueCapacity();
    }

    @Override
    public void allocate() {
        this.vector.allocateNew();
    }

    @Override
    public void close() {
        this.vector.close();
    }

    @Override
    public void clear() {
        this.vector.clear();
    }

    @Override
    protected int idx() {
        return super.idx();
    }

    @Override
    public void write(TimeStampNanoTZHolder h2) {
        this.vector.setSafe(this.idx(), h2);
        this.vector.setValueCount(this.idx() + 1);
    }

    public void write(NullableTimeStampNanoTZHolder h2) {
        this.vector.setSafe(this.idx(), h2);
        this.vector.setValueCount(this.idx() + 1);
    }

    @Override
    public void writeTimeStampNanoTZ(long value) {
        this.vector.setSafe(this.idx(), 1, value);
        this.vector.setValueCount(this.idx() + 1);
    }

    @Override
    public void writeNull() {
        this.vector.setNull(this.idx());
        this.vector.setValueCount(this.idx() + 1);
    }
}

