/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc;

import com.databricks.client.jdbc.Driver;
import com.databricks.internal.google.common.annotations.VisibleForTesting;
import com.databricks.jdbc.common.DatabricksJdbcUrlParams;
import com.databricks.jdbc.exception.DatabricksSQLException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import com.databricks.jdbc.pooling.DatabricksPooledConnection;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public class DataSource
implements javax.sql.DataSource,
ConnectionPoolDataSource {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(DataSource.class);
    private String user = "token";
    private String host;
    private int port;
    private String httpPath;
    private Properties properties = new Properties();
    private final Driver driver;

    public DataSource() {
        this.driver = Driver.getInstance();
    }

    @VisibleForTesting
    public DataSource(Driver driver) {
        this.driver = driver;
    }

    @Override
    public Connection getConnection() throws DatabricksSQLException {
        LOGGER.debug("public Connection getConnection()");
        return this.getConnection(this.getUsername(), this.getPassword());
    }

    @Override
    public Connection getConnection(String username, String password) throws DatabricksSQLException {
        LOGGER.debug("public Connection getConnection(String, String)");
        if (username != null) {
            this.setUsername(username);
        }
        if (password != null) {
            this.setPassword(password);
        }
        return this.driver.connect(this.getUrl(), this.properties);
    }

    @Override
    public PooledConnection getPooledConnection() throws DatabricksSQLException {
        LOGGER.debug("public PooledConnection getPooledConnection()");
        return new DatabricksPooledConnection(this.getConnection());
    }

    @Override
    public PooledConnection getPooledConnection(String user, String password) throws DatabricksSQLException {
        LOGGER.debug("public PooledConnection getPooledConnection(String, String)");
        return new DatabricksPooledConnection(this.getConnection(user, password));
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        throw new SQLFeatureNotSupportedException("public PrintWriter getLogWriter()");
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        throw new SQLFeatureNotSupportedException("public void setLogWriter(PrintWriter out)");
    }

    @Override
    public void setLoginTimeout(int seconds) {
        LOGGER.debug("public void setLoginTimeout(int seconds = {})", seconds);
        this.properties.put("loginTimeout", (Object)seconds);
    }

    @Override
    public int getLoginTimeout() {
        return (Integer)this.properties.get("loginTimeout");
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("public Logger getParentLogger()");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    public String getUrl() {
        LOGGER.debug("public String getUrl()");
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append("jdbc:databricks://");
        if (this.host == null) {
            throw new IllegalStateException("Host is required");
        }
        urlBuilder.append(this.host);
        if (this.port != 0) {
            urlBuilder.append(":").append(this.port);
        }
        if (this.httpPath != null) {
            urlBuilder.append(";").append(DatabricksJdbcUrlParams.HTTP_PATH.getParamName()).append("=").append(this.httpPath);
        }
        return urlBuilder.toString();
    }

    public String getUsername() {
        return this.user;
    }

    public void setUsername(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.properties.getProperty(DatabricksJdbcUrlParams.PASSWORD.getParamName(), this.properties.getProperty(DatabricksJdbcUrlParams.PWD.getParamName()));
    }

    public void setPassword(String password) {
        this.properties.put(DatabricksJdbcUrlParams.PASSWORD.getParamName(), password);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getHttpPath() {
        return this.httpPath;
    }

    public void setHttpPath(String httpPath) {
        this.httpPath = httpPath;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }
}

