/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.common.util;

import com.databricks.jdbc.api.internal.IDatabricksConnectionContext;
import com.databricks.jdbc.common.DatabricksJdbcConstants;

public class VolumeRetryUtil {
    public static final int MAX_RETRIES = 3;

    public static boolean isRetryableHttpCode(int statusCode, IDatabricksConnectionContext connectionContext) {
        if (connectionContext != null) {
            return connectionContext.getUCIngestionRetriableHttpCodes().contains(statusCode);
        }
        return DatabricksJdbcConstants.DEFAULT_UC_INGESTION_RETRYABLE_HTTP_CODES.contains(statusCode);
    }

    public static boolean shouldRetry(int attempt, long retryStartTime, IDatabricksConnectionContext connectionContext) {
        if (attempt >= 3) {
            return false;
        }
        long elapsedSeconds = (System.currentTimeMillis() - retryStartTime) / 1000L;
        int timeoutSeconds = connectionContext != null ? connectionContext.getUCIngestionRetryTimeoutSeconds() : 900;
        return elapsedSeconds < (long)timeoutSeconds;
    }

    public static int getRetryTimeoutSeconds(IDatabricksConnectionContext connectionContext) {
        return connectionContext != null ? connectionContext.getUCIngestionRetryTimeoutSeconds() : 900;
    }
}

