/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.common.util;

import com.databricks.internal.google.common.annotations.VisibleForTesting;
import com.databricks.jdbc.common.LogLevel;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import com.databricks.jdbc.log.JulLogger;
import java.io.IOException;
import java.util.logging.Level;

public class LoggingUtil {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(LoggingUtil.class);

    public static void setupLogger(String logDir, int logFileSizeMB, int logFileCount, LogLevel level) throws IOException {
        if (LOGGER instanceof JulLogger && System.getProperty("java.util.logging.config.file") == null) {
            JulLogger.initLogger(LoggingUtil.toJulLevel(level), logDir, logFileSizeMB * 1024 * 1024, logFileCount);
            LOGGER.info("Setting up JUL logger");
        }
    }

    @VisibleForTesting
    static Level toJulLevel(LogLevel level) {
        switch (level) {
            case DEBUG: {
                return Level.FINE;
            }
            case ERROR: 
            case FATAL: {
                return Level.SEVERE;
            }
            case INFO: {
                return Level.INFO;
            }
            case TRACE: {
                return Level.FINEST;
            }
            case WARN: {
                return Level.WARNING;
            }
        }
        return Level.OFF;
    }
}

