/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl.arrow.incubator;

import com.databricks.internal.sdk.service.sql.BaseChunkInfo;
import com.databricks.jdbc.api.impl.arrow.AbstractArrowResultChunk;
import com.databricks.jdbc.api.impl.arrow.AbstractRemoteChunkProvider;
import com.databricks.jdbc.api.impl.arrow.incubator.ArrowResultChunkV2;
import com.databricks.jdbc.api.internal.IDatabricksSession;
import com.databricks.jdbc.api.internal.IDatabricksStatementInternal;
import com.databricks.jdbc.common.CompressionCodec;
import com.databricks.jdbc.dbclient.IDatabricksHttpClient;
import com.databricks.jdbc.dbclient.impl.common.StatementId;
import com.databricks.jdbc.exception.DatabricksSQLException;
import com.databricks.jdbc.model.client.thrift.generated.TFetchResultsResp;
import com.databricks.jdbc.model.client.thrift.generated.TSparkArrowResultLink;
import com.databricks.jdbc.model.core.ExternalLink;
import com.databricks.jdbc.model.core.ResultData;
import com.databricks.jdbc.model.core.ResultManifest;
import com.databricks.jdbc.model.telemetry.enums.DatabricksDriverErrorCode;
import java.util.concurrent.ExecutionException;

public class RemoteChunkProviderV2
extends AbstractRemoteChunkProvider<ArrowResultChunkV2> {
    private final double downloadSpeedThresholdForWaring;

    public RemoteChunkProviderV2(StatementId statementId, ResultManifest resultManifest, ResultData resultData, IDatabricksSession session, IDatabricksHttpClient httpClient, int maxParallelChunkDownloadsPerQuery) throws DatabricksSQLException {
        super(statementId, resultManifest, resultData, session, httpClient, maxParallelChunkDownloadsPerQuery, resultManifest.getResultCompression());
        this.downloadSpeedThresholdForWaring = session.getConnectionContext().getCloudFetchSpeedThreshold();
    }

    public RemoteChunkProviderV2(IDatabricksStatementInternal parentStatement, TFetchResultsResp resultsResp, IDatabricksSession session, IDatabricksHttpClient httpClient, int maxParallelChunkDownloadsPerQuery, CompressionCodec compressionCodec) throws DatabricksSQLException {
        super(parentStatement, resultsResp, session, httpClient, maxParallelChunkDownloadsPerQuery, compressionCodec);
        this.downloadSpeedThresholdForWaring = session.getConnectionContext().getCloudFetchSpeedThreshold();
    }

    @Override
    protected ArrowResultChunkV2 createChunk(StatementId statementId, long chunkIndex, BaseChunkInfo chunkInfo) {
        return ArrowResultChunkV2.builder().withStatementId(statementId).withChunkInfo(chunkInfo).build();
    }

    @Override
    protected ArrowResultChunkV2 createChunk(StatementId statementId, long chunkIndex, TSparkArrowResultLink resultLink) {
        return ArrowResultChunkV2.builder().withStatementId(statementId).withThriftChunkInfo(chunkIndex, resultLink).build();
    }

    @Override
    public void downloadNextChunks() throws DatabricksSQLException {
        while (!this.isClosed && this.nextChunkToDownload < this.chunkCount && this.totalChunksInMemory < this.allowedChunksInMemory) {
            ArrowResultChunkV2 chunk = (ArrowResultChunkV2)this.chunkIndexToChunksMap.get(this.nextChunkToDownload);
            ++this.totalChunksInMemory;
            if (chunk.isChunkLinkInvalid()) {
                try {
                    ExternalLink link = this.linkDownloadService.getLinkForChunk(chunk.getChunkIndex()).get();
                    chunk.setChunkLink(link);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new DatabricksSQLException("Chunk link download interrupted", (Throwable)e, DatabricksDriverErrorCode.THREAD_INTERRUPTED_ERROR);
                }
                catch (ExecutionException e) {
                    throw new DatabricksSQLException("Chunk link download failed", (Throwable)e, DatabricksDriverErrorCode.CHUNK_DOWNLOAD_ERROR);
                }
            }
            chunk.downloadData(this.httpClient, this.getCompressionCodec(), this.downloadSpeedThresholdForWaring);
            ++this.nextChunkToDownload;
        }
    }

    @Override
    protected void doClose() {
        this.isClosed = true;
        this.chunkIndexToChunksMap.values().forEach(AbstractArrowResultChunk::releaseChunk);
    }
}

