/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl;

import com.databricks.internal.google.common.collect.ImmutableMap;
import java.util.Map;

class CaseInsensitiveImmutableMap<V> {
    private final ImmutableMap<String, V> delegate;

    private CaseInsensitiveImmutableMap(ImmutableMap<String, V> delegate) {
        this.delegate = delegate;
    }

    public static <V> CaseInsensitiveImmutableMap<V> copyOf(Map<String, V> map) {
        ImmutableMap<String, Object> normalizedMap = map.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((String)entry.getKey()).toLowerCase(), Map.Entry::getValue));
        return new CaseInsensitiveImmutableMap<Object>(normalizedMap);
    }

    public V get(String key) {
        return this.delegate.get(key.toLowerCase());
    }

    public V getOrDefault(String key, V defaultValue) {
        return this.delegate.getOrDefault(key.toLowerCase(), defaultValue);
    }

    public boolean containsKey(String key) {
        return this.delegate.containsKey(key.toLowerCase());
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }
}

